/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemDataValue;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemNotification;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemStatus;
import com.amazonaws.services.simplesystemsmanagement.model.RelatedOpsItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateOpsItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private Map<String, OpsItemDataValue> operationalData;
    private SdkInternalList<String> operationalDataToDelete;
    private SdkInternalList<OpsItemNotification> notifications;
    private Integer priority;
    private SdkInternalList<RelatedOpsItem> relatedOpsItems;
    private String status;
    private String opsItemId;
    private String title;
    private String category;
    private String severity;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateOpsItemRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, OpsItemDataValue> getOperationalData() {
        return this.operationalData;
    }

    public void setOperationalData(Map<String, OpsItemDataValue> operationalData) {
        this.operationalData = operationalData;
    }

    public UpdateOpsItemRequest withOperationalData(Map<String, OpsItemDataValue> operationalData) {
        this.setOperationalData(operationalData);
        return this;
    }

    public UpdateOpsItemRequest addOperationalDataEntry(String key, OpsItemDataValue value) {
        if (null == this.operationalData) {
            this.operationalData = new HashMap<String, OpsItemDataValue>();
        }
        if (this.operationalData.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.operationalData.put(key, value);
        return this;
    }

    public UpdateOpsItemRequest clearOperationalDataEntries() {
        this.operationalData = null;
        return this;
    }

    public List<String> getOperationalDataToDelete() {
        if (this.operationalDataToDelete == null) {
            this.operationalDataToDelete = new SdkInternalList();
        }
        return this.operationalDataToDelete;
    }

    public void setOperationalDataToDelete(Collection<String> operationalDataToDelete) {
        if (operationalDataToDelete == null) {
            this.operationalDataToDelete = null;
            return;
        }
        this.operationalDataToDelete = new SdkInternalList(operationalDataToDelete);
    }

    public UpdateOpsItemRequest withOperationalDataToDelete(String ... operationalDataToDelete) {
        if (this.operationalDataToDelete == null) {
            this.setOperationalDataToDelete((Collection<String>)new SdkInternalList(operationalDataToDelete.length));
        }
        for (String ele : operationalDataToDelete) {
            this.operationalDataToDelete.add((Object)ele);
        }
        return this;
    }

    public UpdateOpsItemRequest withOperationalDataToDelete(Collection<String> operationalDataToDelete) {
        this.setOperationalDataToDelete(operationalDataToDelete);
        return this;
    }

    public List<OpsItemNotification> getNotifications() {
        if (this.notifications == null) {
            this.notifications = new SdkInternalList();
        }
        return this.notifications;
    }

    public void setNotifications(Collection<OpsItemNotification> notifications) {
        if (notifications == null) {
            this.notifications = null;
            return;
        }
        this.notifications = new SdkInternalList(notifications);
    }

    public UpdateOpsItemRequest withNotifications(OpsItemNotification ... notifications) {
        if (this.notifications == null) {
            this.setNotifications((Collection<OpsItemNotification>)new SdkInternalList(notifications.length));
        }
        for (OpsItemNotification ele : notifications) {
            this.notifications.add((Object)ele);
        }
        return this;
    }

    public UpdateOpsItemRequest withNotifications(Collection<OpsItemNotification> notifications) {
        this.setNotifications(notifications);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public UpdateOpsItemRequest withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public List<RelatedOpsItem> getRelatedOpsItems() {
        if (this.relatedOpsItems == null) {
            this.relatedOpsItems = new SdkInternalList();
        }
        return this.relatedOpsItems;
    }

    public void setRelatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
        if (relatedOpsItems == null) {
            this.relatedOpsItems = null;
            return;
        }
        this.relatedOpsItems = new SdkInternalList(relatedOpsItems);
    }

    public UpdateOpsItemRequest withRelatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
        if (this.relatedOpsItems == null) {
            this.setRelatedOpsItems((Collection<RelatedOpsItem>)new SdkInternalList(relatedOpsItems.length));
        }
        for (RelatedOpsItem ele : relatedOpsItems) {
            this.relatedOpsItems.add((Object)ele);
        }
        return this;
    }

    public UpdateOpsItemRequest withRelatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
        this.setRelatedOpsItems(relatedOpsItems);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public UpdateOpsItemRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public UpdateOpsItemRequest withStatus(OpsItemStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setOpsItemId(String opsItemId) {
        this.opsItemId = opsItemId;
    }

    public String getOpsItemId() {
        return this.opsItemId;
    }

    public UpdateOpsItemRequest withOpsItemId(String opsItemId) {
        this.setOpsItemId(opsItemId);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public UpdateOpsItemRequest withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public UpdateOpsItemRequest withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public UpdateOpsItemRequest withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOperationalData() != null) {
            sb.append("OperationalData: ").append(this.getOperationalData()).append(",");
        }
        if (this.getOperationalDataToDelete() != null) {
            sb.append("OperationalDataToDelete: ").append(this.getOperationalDataToDelete()).append(",");
        }
        if (this.getNotifications() != null) {
            sb.append("Notifications: ").append(this.getNotifications()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getRelatedOpsItems() != null) {
            sb.append("RelatedOpsItems: ").append(this.getRelatedOpsItems()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getOpsItemId() != null) {
            sb.append("OpsItemId: ").append(this.getOpsItemId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpsItemRequest)) {
            return false;
        }
        UpdateOpsItemRequest other = (UpdateOpsItemRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOperationalData() == null ^ this.getOperationalData() == null) {
            return false;
        }
        if (other.getOperationalData() != null && !other.getOperationalData().equals(this.getOperationalData())) {
            return false;
        }
        if (other.getOperationalDataToDelete() == null ^ this.getOperationalDataToDelete() == null) {
            return false;
        }
        if (other.getOperationalDataToDelete() != null && !other.getOperationalDataToDelete().equals(this.getOperationalDataToDelete())) {
            return false;
        }
        if (other.getNotifications() == null ^ this.getNotifications() == null) {
            return false;
        }
        if (other.getNotifications() != null && !other.getNotifications().equals(this.getNotifications())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getRelatedOpsItems() == null ^ this.getRelatedOpsItems() == null) {
            return false;
        }
        if (other.getRelatedOpsItems() != null && !other.getRelatedOpsItems().equals(this.getRelatedOpsItems())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getOpsItemId() == null ^ this.getOpsItemId() == null) {
            return false;
        }
        if (other.getOpsItemId() != null && !other.getOpsItemId().equals(this.getOpsItemId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        return other.getSeverity() == null || other.getSeverity().equals(this.getSeverity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOperationalData() == null ? 0 : this.getOperationalData().hashCode());
        hashCode = 31 * hashCode + (this.getOperationalDataToDelete() == null ? 0 : this.getOperationalDataToDelete().hashCode());
        hashCode = 31 * hashCode + (this.getNotifications() == null ? 0 : this.getNotifications().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedOpsItems() == null ? 0 : this.getRelatedOpsItems().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getOpsItemId() == null ? 0 : this.getOpsItemId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        return hashCode;
    }

    public UpdateOpsItemRequest clone() {
        return (UpdateOpsItemRequest)super.clone();
    }
}

