/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakeredgemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakeredgemanager.model.Definition;

@SdkInternalApi
public class DefinitionMarshaller {
    private static final MarshallingInfo<String> MODELHANDLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelHandle").build();
    private static final MarshallingInfo<String> S3URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Url").build();
    private static final MarshallingInfo<StructuredPojo> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Checksum").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final DefinitionMarshaller instance = new DefinitionMarshaller();

    public static DefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Definition definition, ProtocolMarshaller protocolMarshaller) {
        if (definition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)definition.getModelHandle(), MODELHANDLE_BINDING);
            protocolMarshaller.marshall((Object)definition.getS3Url(), S3URL_BINDING);
            protocolMarshaller.marshall((Object)definition.getChecksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)definition.getState(), STATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

