/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetScalingConfigurationRecommendation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetScalingConfigurationRecommendationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of a previously completed Inference Recommender job.
     * </p>
     */
    private String inferenceRecommendationsJobName;
    /**
     * <p>
     * The recommendation ID of a previously completed inference recommendation. This ID should come from one of the
     * recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>EndpointName</code> field.
     * </p>
     */
    private String recommendationId;
    /**
     * <p>
     * The name of an endpoint benchmarked during a previously completed inference recommendation job. This name should
     * come from one of the recommendations returned by the job specified in the
     * <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>RecommendationId</code> field.
     * </p>
     */
    private String endpointName;
    /**
     * <p>
     * The percentage of how much utilization you want an instance to use before autoscaling. The default value is 50%.
     * </p>
     */
    private Integer targetCpuUtilizationPerCore;
    /**
     * <p>
     * An object where you specify the anticipated traffic pattern for an endpoint.
     * </p>
     */
    private ScalingPolicyObjective scalingPolicyObjective;

    /**
     * <p>
     * The name of a previously completed Inference Recommender job.
     * </p>
     * 
     * @param inferenceRecommendationsJobName
     *        The name of a previously completed Inference Recommender job.
     */

    public void setInferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
        this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
    }

    /**
     * <p>
     * The name of a previously completed Inference Recommender job.
     * </p>
     * 
     * @return The name of a previously completed Inference Recommender job.
     */

    public String getInferenceRecommendationsJobName() {
        return this.inferenceRecommendationsJobName;
    }

    /**
     * <p>
     * The name of a previously completed Inference Recommender job.
     * </p>
     * 
     * @param inferenceRecommendationsJobName
     *        The name of a previously completed Inference Recommender job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetScalingConfigurationRecommendationRequest withInferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
        setInferenceRecommendationsJobName(inferenceRecommendationsJobName);
        return this;
    }

    /**
     * <p>
     * The recommendation ID of a previously completed inference recommendation. This ID should come from one of the
     * recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>EndpointName</code> field.
     * </p>
     * 
     * @param recommendationId
     *        The recommendation ID of a previously completed inference recommendation. This ID should come from one of
     *        the recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code>
     *        field.</p>
     *        <p>
     *        Specify either this field or the <code>EndpointName</code> field.
     */

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    /**
     * <p>
     * The recommendation ID of a previously completed inference recommendation. This ID should come from one of the
     * recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>EndpointName</code> field.
     * </p>
     * 
     * @return The recommendation ID of a previously completed inference recommendation. This ID should come from one of
     *         the recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code>
     *         field.</p>
     *         <p>
     *         Specify either this field or the <code>EndpointName</code> field.
     */

    public String getRecommendationId() {
        return this.recommendationId;
    }

    /**
     * <p>
     * The recommendation ID of a previously completed inference recommendation. This ID should come from one of the
     * recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>EndpointName</code> field.
     * </p>
     * 
     * @param recommendationId
     *        The recommendation ID of a previously completed inference recommendation. This ID should come from one of
     *        the recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code>
     *        field.</p>
     *        <p>
     *        Specify either this field or the <code>EndpointName</code> field.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetScalingConfigurationRecommendationRequest withRecommendationId(String recommendationId) {
        setRecommendationId(recommendationId);
        return this;
    }

    /**
     * <p>
     * The name of an endpoint benchmarked during a previously completed inference recommendation job. This name should
     * come from one of the recommendations returned by the job specified in the
     * <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>RecommendationId</code> field.
     * </p>
     * 
     * @param endpointName
     *        The name of an endpoint benchmarked during a previously completed inference recommendation job. This name
     *        should come from one of the recommendations returned by the job specified in the
     *        <code>InferenceRecommendationsJobName</code> field.</p>
     *        <p>
     *        Specify either this field or the <code>RecommendationId</code> field.
     */

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    /**
     * <p>
     * The name of an endpoint benchmarked during a previously completed inference recommendation job. This name should
     * come from one of the recommendations returned by the job specified in the
     * <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>RecommendationId</code> field.
     * </p>
     * 
     * @return The name of an endpoint benchmarked during a previously completed inference recommendation job. This name
     *         should come from one of the recommendations returned by the job specified in the
     *         <code>InferenceRecommendationsJobName</code> field.</p>
     *         <p>
     *         Specify either this field or the <code>RecommendationId</code> field.
     */

    public String getEndpointName() {
        return this.endpointName;
    }

    /**
     * <p>
     * The name of an endpoint benchmarked during a previously completed inference recommendation job. This name should
     * come from one of the recommendations returned by the job specified in the
     * <code>InferenceRecommendationsJobName</code> field.
     * </p>
     * <p>
     * Specify either this field or the <code>RecommendationId</code> field.
     * </p>
     * 
     * @param endpointName
     *        The name of an endpoint benchmarked during a previously completed inference recommendation job. This name
     *        should come from one of the recommendations returned by the job specified in the
     *        <code>InferenceRecommendationsJobName</code> field.</p>
     *        <p>
     *        Specify either this field or the <code>RecommendationId</code> field.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetScalingConfigurationRecommendationRequest withEndpointName(String endpointName) {
        setEndpointName(endpointName);
        return this;
    }

    /**
     * <p>
     * The percentage of how much utilization you want an instance to use before autoscaling. The default value is 50%.
     * </p>
     * 
     * @param targetCpuUtilizationPerCore
     *        The percentage of how much utilization you want an instance to use before autoscaling. The default value
     *        is 50%.
     */

    public void setTargetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
        this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
    }

    /**
     * <p>
     * The percentage of how much utilization you want an instance to use before autoscaling. The default value is 50%.
     * </p>
     * 
     * @return The percentage of how much utilization you want an instance to use before autoscaling. The default value
     *         is 50%.
     */

    public Integer getTargetCpuUtilizationPerCore() {
        return this.targetCpuUtilizationPerCore;
    }

    /**
     * <p>
     * The percentage of how much utilization you want an instance to use before autoscaling. The default value is 50%.
     * </p>
     * 
     * @param targetCpuUtilizationPerCore
     *        The percentage of how much utilization you want an instance to use before autoscaling. The default value
     *        is 50%.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetScalingConfigurationRecommendationRequest withTargetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
        setTargetCpuUtilizationPerCore(targetCpuUtilizationPerCore);
        return this;
    }

    /**
     * <p>
     * An object where you specify the anticipated traffic pattern for an endpoint.
     * </p>
     * 
     * @param scalingPolicyObjective
     *        An object where you specify the anticipated traffic pattern for an endpoint.
     */

    public void setScalingPolicyObjective(ScalingPolicyObjective scalingPolicyObjective) {
        this.scalingPolicyObjective = scalingPolicyObjective;
    }

    /**
     * <p>
     * An object where you specify the anticipated traffic pattern for an endpoint.
     * </p>
     * 
     * @return An object where you specify the anticipated traffic pattern for an endpoint.
     */

    public ScalingPolicyObjective getScalingPolicyObjective() {
        return this.scalingPolicyObjective;
    }

    /**
     * <p>
     * An object where you specify the anticipated traffic pattern for an endpoint.
     * </p>
     * 
     * @param scalingPolicyObjective
     *        An object where you specify the anticipated traffic pattern for an endpoint.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetScalingConfigurationRecommendationRequest withScalingPolicyObjective(ScalingPolicyObjective scalingPolicyObjective) {
        setScalingPolicyObjective(scalingPolicyObjective);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInferenceRecommendationsJobName() != null)
            sb.append("InferenceRecommendationsJobName: ").append(getInferenceRecommendationsJobName()).append(",");
        if (getRecommendationId() != null)
            sb.append("RecommendationId: ").append(getRecommendationId()).append(",");
        if (getEndpointName() != null)
            sb.append("EndpointName: ").append(getEndpointName()).append(",");
        if (getTargetCpuUtilizationPerCore() != null)
            sb.append("TargetCpuUtilizationPerCore: ").append(getTargetCpuUtilizationPerCore()).append(",");
        if (getScalingPolicyObjective() != null)
            sb.append("ScalingPolicyObjective: ").append(getScalingPolicyObjective());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetScalingConfigurationRecommendationRequest == false)
            return false;
        GetScalingConfigurationRecommendationRequest other = (GetScalingConfigurationRecommendationRequest) obj;
        if (other.getInferenceRecommendationsJobName() == null ^ this.getInferenceRecommendationsJobName() == null)
            return false;
        if (other.getInferenceRecommendationsJobName() != null
                && other.getInferenceRecommendationsJobName().equals(this.getInferenceRecommendationsJobName()) == false)
            return false;
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null)
            return false;
        if (other.getRecommendationId() != null && other.getRecommendationId().equals(this.getRecommendationId()) == false)
            return false;
        if (other.getEndpointName() == null ^ this.getEndpointName() == null)
            return false;
        if (other.getEndpointName() != null && other.getEndpointName().equals(this.getEndpointName()) == false)
            return false;
        if (other.getTargetCpuUtilizationPerCore() == null ^ this.getTargetCpuUtilizationPerCore() == null)
            return false;
        if (other.getTargetCpuUtilizationPerCore() != null && other.getTargetCpuUtilizationPerCore().equals(this.getTargetCpuUtilizationPerCore()) == false)
            return false;
        if (other.getScalingPolicyObjective() == null ^ this.getScalingPolicyObjective() == null)
            return false;
        if (other.getScalingPolicyObjective() != null && other.getScalingPolicyObjective().equals(this.getScalingPolicyObjective()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInferenceRecommendationsJobName() == null) ? 0 : getInferenceRecommendationsJobName().hashCode());
        hashCode = prime * hashCode + ((getRecommendationId() == null) ? 0 : getRecommendationId().hashCode());
        hashCode = prime * hashCode + ((getEndpointName() == null) ? 0 : getEndpointName().hashCode());
        hashCode = prime * hashCode + ((getTargetCpuUtilizationPerCore() == null) ? 0 : getTargetCpuUtilizationPerCore().hashCode());
        hashCode = prime * hashCode + ((getScalingPolicyObjective() == null) ? 0 : getScalingPolicyObjective().hashCode());
        return hashCode;
    }

    @Override
    public GetScalingConfigurationRecommendationRequest clone() {
        return (GetScalingConfigurationRecommendationRequest) super.clone();
    }

}
