/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AppInstanceType;
import com.amazonaws.services.sagemaker.model.transform.ResourceSpecMarshaller;
import java.io.Serializable;

public class ResourceSpec
implements Serializable,
Cloneable,
StructuredPojo {
    private String environmentArn;
    private String instanceType;

    public void setEnvironmentArn(String environmentArn) {
        this.environmentArn = environmentArn;
    }

    public String getEnvironmentArn() {
        return this.environmentArn;
    }

    public ResourceSpec withEnvironmentArn(String environmentArn) {
        this.setEnvironmentArn(environmentArn);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ResourceSpec withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public ResourceSpec withInstanceType(AppInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentArn() != null) {
            sb.append("EnvironmentArn: ").append(this.getEnvironmentArn()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec other = (ResourceSpec)obj;
        if (other.getEnvironmentArn() == null ^ this.getEnvironmentArn() == null) {
            return false;
        }
        if (other.getEnvironmentArn() != null && !other.getEnvironmentArn().equals(this.getEnvironmentArn())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        return other.getInstanceType() == null || other.getInstanceType().equals(this.getInstanceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentArn() == null ? 0 : this.getEnvironmentArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        return hashCode;
    }

    public ResourceSpec clone() {
        try {
            return (ResourceSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceSpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

