/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pi.model.Insight;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InsightMarshaller {
    private static final MarshallingInfo<String> INSIGHTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InsightId").build();
    private static final MarshallingInfo<String> INSIGHTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InsightType").build();
    private static final MarshallingInfo<String> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Severity").build();
    private static final MarshallingInfo<List> SUPPORTINGINSIGHTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportingInsights").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> RECOMMENDATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recommendations").build();
    private static final MarshallingInfo<List> INSIGHTDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InsightData").build();
    private static final MarshallingInfo<List> BASELINEDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineData").build();
    private static final InsightMarshaller instance = new InsightMarshaller();

    public static InsightMarshaller getInstance() {
        return instance;
    }

    public void marshall(Insight insight, ProtocolMarshaller protocolMarshaller) {
        if (insight == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)insight.getInsightId(), INSIGHTID_BINDING);
            protocolMarshaller.marshall((Object)insight.getInsightType(), INSIGHTTYPE_BINDING);
            protocolMarshaller.marshall((Object)insight.getContext(), CONTEXT_BINDING);
            protocolMarshaller.marshall((Object)insight.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)insight.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)insight.getSeverity(), SEVERITY_BINDING);
            protocolMarshaller.marshall(insight.getSupportingInsights(), SUPPORTINGINSIGHTS_BINDING);
            protocolMarshaller.marshall((Object)insight.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(insight.getRecommendations(), RECOMMENDATIONS_BINDING);
            protocolMarshaller.marshall(insight.getInsightData(), INSIGHTDATA_BINDING);
            protocolMarshaller.marshall(insight.getBaselineData(), BASELINEDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

