/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mailmanager.model.AcceptAction;
import com.amazonaws.services.mailmanager.model.PolicyStatement;
import com.amazonaws.services.mailmanager.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTrafficPolicyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String defaultAction;
    private Integer maxMessageSizeBytes;
    private List<PolicyStatement> policyStatements;
    private List<Tag> tags;
    private String trafficPolicyName;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateTrafficPolicyRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public CreateTrafficPolicyRequest withDefaultAction(String defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public CreateTrafficPolicyRequest withDefaultAction(AcceptAction defaultAction) {
        this.defaultAction = defaultAction.toString();
        return this;
    }

    public void setMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
        this.maxMessageSizeBytes = maxMessageSizeBytes;
    }

    public Integer getMaxMessageSizeBytes() {
        return this.maxMessageSizeBytes;
    }

    public CreateTrafficPolicyRequest withMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
        this.setMaxMessageSizeBytes(maxMessageSizeBytes);
        return this;
    }

    public List<PolicyStatement> getPolicyStatements() {
        return this.policyStatements;
    }

    public void setPolicyStatements(Collection<PolicyStatement> policyStatements) {
        if (policyStatements == null) {
            this.policyStatements = null;
            return;
        }
        this.policyStatements = new ArrayList<PolicyStatement>(policyStatements);
    }

    public CreateTrafficPolicyRequest withPolicyStatements(PolicyStatement ... policyStatements) {
        if (this.policyStatements == null) {
            this.setPolicyStatements(new ArrayList<PolicyStatement>(policyStatements.length));
        }
        for (PolicyStatement ele : policyStatements) {
            this.policyStatements.add(ele);
        }
        return this;
    }

    public CreateTrafficPolicyRequest withPolicyStatements(Collection<PolicyStatement> policyStatements) {
        this.setPolicyStatements(policyStatements);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateTrafficPolicyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateTrafficPolicyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setTrafficPolicyName(String trafficPolicyName) {
        this.trafficPolicyName = trafficPolicyName;
    }

    public String getTrafficPolicyName() {
        return this.trafficPolicyName;
    }

    public CreateTrafficPolicyRequest withTrafficPolicyName(String trafficPolicyName) {
        this.setTrafficPolicyName(trafficPolicyName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction()).append(",");
        }
        if (this.getMaxMessageSizeBytes() != null) {
            sb.append("MaxMessageSizeBytes: ").append(this.getMaxMessageSizeBytes()).append(",");
        }
        if (this.getPolicyStatements() != null) {
            sb.append("PolicyStatements: ").append(this.getPolicyStatements()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTrafficPolicyName() != null) {
            sb.append("TrafficPolicyName: ").append(this.getTrafficPolicyName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyRequest)) {
            return false;
        }
        CreateTrafficPolicyRequest other = (CreateTrafficPolicyRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        if (other.getDefaultAction() != null && !other.getDefaultAction().equals(this.getDefaultAction())) {
            return false;
        }
        if (other.getMaxMessageSizeBytes() == null ^ this.getMaxMessageSizeBytes() == null) {
            return false;
        }
        if (other.getMaxMessageSizeBytes() != null && !other.getMaxMessageSizeBytes().equals(this.getMaxMessageSizeBytes())) {
            return false;
        }
        if (other.getPolicyStatements() == null ^ this.getPolicyStatements() == null) {
            return false;
        }
        if (other.getPolicyStatements() != null && !other.getPolicyStatements().equals(this.getPolicyStatements())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTrafficPolicyName() == null ^ this.getTrafficPolicyName() == null) {
            return false;
        }
        return other.getTrafficPolicyName() == null || other.getTrafficPolicyName().equals(this.getTrafficPolicyName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        hashCode = 31 * hashCode + (this.getMaxMessageSizeBytes() == null ? 0 : this.getMaxMessageSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyStatements() == null ? 0 : this.getPolicyStatements().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPolicyName() == null ? 0 : this.getTrafficPolicyName().hashCode());
        return hashCode;
    }

    public CreateTrafficPolicyRequest clone() {
        return (CreateTrafficPolicyRequest)super.clone();
    }
}

