/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeRulesPackagesRequestMarshaller
implements Marshaller<Request<DescribeRulesPackagesRequest>, DescribeRulesPackagesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeRulesPackagesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeRulesPackagesRequest> marshall(DescribeRulesPackagesRequest describeRulesPackagesRequest) {
        if (describeRulesPackagesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRulesPackagesRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeRulesPackages");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> rulesPackageArnsList = describeRulesPackagesRequest.getRulesPackageArns();
            if (rulesPackageArnsList != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeRulesPackagesRequest.getLocale() != null) {
                jsonGenerator.writeFieldName("locale").writeValue(describeRulesPackagesRequest.getLocale());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

