/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.AssessmentTemplate;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import java.util.List;

public class AssessmentTemplateJsonMarshaller {
    private static AssessmentTemplateJsonMarshaller instance;

    public void marshall(AssessmentTemplate assessmentTemplate, StructuredJsonGenerator jsonGenerator) {
        if (assessmentTemplate == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesForFindingsList;
            List<String> rulesPackageArnsList;
            jsonGenerator.writeStartObject();
            if (assessmentTemplate.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(assessmentTemplate.getArn());
            }
            if (assessmentTemplate.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(assessmentTemplate.getName());
            }
            if (assessmentTemplate.getAssessmentTargetArn() != null) {
                jsonGenerator.writeFieldName("assessmentTargetArn").writeValue(assessmentTemplate.getAssessmentTargetArn());
            }
            if (assessmentTemplate.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue(assessmentTemplate.getDurationInSeconds().intValue());
            }
            if ((rulesPackageArnsList = assessmentTemplate.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesForFindingsList = assessmentTemplate.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (assessmentTemplate.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(assessmentTemplate.getCreatedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentTemplateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentTemplateJsonMarshaller();
        }
        return instance;
    }
}

