/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.greengrassv2.model.RecipeOutputFormat;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class GetComponentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String recipeOutputFormat;
    private ByteBuffer recipe;
    private Map<String, String> tags;

    public void setRecipeOutputFormat(String recipeOutputFormat) {
        this.recipeOutputFormat = recipeOutputFormat;
    }

    public String getRecipeOutputFormat() {
        return this.recipeOutputFormat;
    }

    public GetComponentResult withRecipeOutputFormat(String recipeOutputFormat) {
        this.setRecipeOutputFormat(recipeOutputFormat);
        return this;
    }

    public GetComponentResult withRecipeOutputFormat(RecipeOutputFormat recipeOutputFormat) {
        this.recipeOutputFormat = recipeOutputFormat.toString();
        return this;
    }

    public void setRecipe(ByteBuffer recipe) {
        this.recipe = recipe;
    }

    public ByteBuffer getRecipe() {
        return this.recipe;
    }

    public GetComponentResult withRecipe(ByteBuffer recipe) {
        this.setRecipe(recipe);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public GetComponentResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GetComponentResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GetComponentResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecipeOutputFormat() != null) {
            sb.append("RecipeOutputFormat: ").append(this.getRecipeOutputFormat()).append(",");
        }
        if (this.getRecipe() != null) {
            sb.append("Recipe: ").append(this.getRecipe()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentResult)) {
            return false;
        }
        GetComponentResult other = (GetComponentResult)obj;
        if (other.getRecipeOutputFormat() == null ^ this.getRecipeOutputFormat() == null) {
            return false;
        }
        if (other.getRecipeOutputFormat() != null && !other.getRecipeOutputFormat().equals(this.getRecipeOutputFormat())) {
            return false;
        }
        if (other.getRecipe() == null ^ this.getRecipe() == null) {
            return false;
        }
        if (other.getRecipe() != null && !other.getRecipe().equals(this.getRecipe())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecipeOutputFormat() == null ? 0 : this.getRecipeOutputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getRecipe() == null ? 0 : this.getRecipe().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public GetComponentResult clone() {
        try {
            return (GetComponentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

