/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RuleCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyRuleRequestMarshaller
implements Marshaller<Request<ModifyRuleRequest>, ModifyRuleRequest> {
    public Request<ModifyRuleRequest> marshall(ModifyRuleRequest modifyRuleRequest) {
        if (modifyRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyRuleRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyRuleRequest.getRuleArn() != null) {
            request.addParameter("RuleArn", StringUtils.fromString((String)modifyRuleRequest.getRuleArn()));
        }
        if (modifyRuleRequest.getConditions() != null) {
            List<RuleCondition> conditionsList = modifyRuleRequest.getConditions();
            if (conditionsList.isEmpty()) {
                request.addParameter("Conditions", "");
            } else {
                int conditionsListIndex = 1;
                for (RuleCondition conditionsListValue : conditionsList) {
                    if (conditionsListValue.getField() != null) {
                        request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringUtils.fromString((String)conditionsListValue.getField()));
                    }
                    if (conditionsListValue.getValues() != null) {
                        List<String> valuesList = conditionsListValue.getValues();
                        if (valuesList.isEmpty()) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                        } else {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        }
                    }
                    ++conditionsListIndex;
                }
            }
        }
        if (modifyRuleRequest.getActions() != null) {
            List<Action> actionsList = modifyRuleRequest.getActions();
            if (actionsList.isEmpty()) {
                request.addParameter("Actions", "");
            } else {
                int actionsListIndex = 1;
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue.getType() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".Type", StringUtils.fromString((String)actionsListValue.getType()));
                    }
                    if (actionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)actionsListValue.getTargetGroupArn()));
                    }
                    ++actionsListIndex;
                }
            }
        }
        return request;
    }
}

