/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<UpdateConfigurationTemplateRequest>, UpdateConfigurationTemplateRequest> {
    public Request<UpdateConfigurationTemplateRequest> marshall(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        if (updateConfigurationTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateConfigurationTemplateRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "UpdateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationTemplateRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)updateConfigurationTemplateRequest.getApplicationName()));
        }
        if (updateConfigurationTemplateRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)updateConfigurationTemplateRequest.getTemplateName()));
        }
        if (updateConfigurationTemplateRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateConfigurationTemplateRequest.getDescription()));
        }
        if (!updateConfigurationTemplateRequest.getOptionSettings().isEmpty() || !((SdkInternalList)updateConfigurationTemplateRequest.getOptionSettings()).isAutoConstruct()) {
            SdkInternalList optionSettingsList = (SdkInternalList)updateConfigurationTemplateRequest.getOptionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue != null) {
                    if (optionSettingsListValue.getResourceName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.getResourceName()));
                    }
                    if (optionSettingsListValue.getNamespace() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.getNamespace()));
                    }
                    if (optionSettingsListValue.getOptionName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.getOptionName()));
                    }
                    if (optionSettingsListValue.getValue() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.getValue()));
                    }
                }
                ++optionSettingsListIndex;
            }
        }
        if (!updateConfigurationTemplateRequest.getOptionsToRemove().isEmpty() || !((SdkInternalList)updateConfigurationTemplateRequest.getOptionsToRemove()).isAutoConstruct()) {
            SdkInternalList optionsToRemoveList = (SdkInternalList)updateConfigurationTemplateRequest.getOptionsToRemove();
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue != null) {
                    if (optionsToRemoveListValue.getResourceName() != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringUtils.fromString((String)optionsToRemoveListValue.getResourceName()));
                    }
                    if (optionsToRemoveListValue.getNamespace() != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString((String)optionsToRemoveListValue.getNamespace()));
                    }
                    if (optionsToRemoveListValue.getOptionName() != null) {
                        request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString((String)optionsToRemoveListValue.getOptionName()));
                    }
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

