/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceResult;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetIpamDiscoveredResourceCidrsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * Discovered resource CIDRs.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs;
    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Discovered resource CIDRs.
     * </p>
     * 
     * @return Discovered resource CIDRs.
     */

    public java.util.List<IpamDiscoveredResourceCidr> getIpamDiscoveredResourceCidrs() {
        if (ipamDiscoveredResourceCidrs == null) {
            ipamDiscoveredResourceCidrs = new com.amazonaws.internal.SdkInternalList<IpamDiscoveredResourceCidr>();
        }
        return ipamDiscoveredResourceCidrs;
    }

    /**
     * <p>
     * Discovered resource CIDRs.
     * </p>
     * 
     * @param ipamDiscoveredResourceCidrs
     *        Discovered resource CIDRs.
     */

    public void setIpamDiscoveredResourceCidrs(java.util.Collection<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs) {
        if (ipamDiscoveredResourceCidrs == null) {
            this.ipamDiscoveredResourceCidrs = null;
            return;
        }

        this.ipamDiscoveredResourceCidrs = new com.amazonaws.internal.SdkInternalList<IpamDiscoveredResourceCidr>(ipamDiscoveredResourceCidrs);
    }

    /**
     * <p>
     * Discovered resource CIDRs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIpamDiscoveredResourceCidrs(java.util.Collection)} or
     * {@link #withIpamDiscoveredResourceCidrs(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param ipamDiscoveredResourceCidrs
     *        Discovered resource CIDRs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetIpamDiscoveredResourceCidrsResult withIpamDiscoveredResourceCidrs(IpamDiscoveredResourceCidr... ipamDiscoveredResourceCidrs) {
        if (this.ipamDiscoveredResourceCidrs == null) {
            setIpamDiscoveredResourceCidrs(new com.amazonaws.internal.SdkInternalList<IpamDiscoveredResourceCidr>(ipamDiscoveredResourceCidrs.length));
        }
        for (IpamDiscoveredResourceCidr ele : ipamDiscoveredResourceCidrs) {
            this.ipamDiscoveredResourceCidrs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Discovered resource CIDRs.
     * </p>
     * 
     * @param ipamDiscoveredResourceCidrs
     *        Discovered resource CIDRs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetIpamDiscoveredResourceCidrsResult withIpamDiscoveredResourceCidrs(java.util.Collection<IpamDiscoveredResourceCidr> ipamDiscoveredResourceCidrs) {
        setIpamDiscoveredResourceCidrs(ipamDiscoveredResourceCidrs);
        return this;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @param nextToken
     *        Specify the pagination token from a previous request to retrieve the next page of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @param nextToken
     *        Specify the pagination token from a previous request to retrieve the next page of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetIpamDiscoveredResourceCidrsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIpamDiscoveredResourceCidrs() != null)
            sb.append("IpamDiscoveredResourceCidrs: ").append(getIpamDiscoveredResourceCidrs()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetIpamDiscoveredResourceCidrsResult == false)
            return false;
        GetIpamDiscoveredResourceCidrsResult other = (GetIpamDiscoveredResourceCidrsResult) obj;
        if (other.getIpamDiscoveredResourceCidrs() == null ^ this.getIpamDiscoveredResourceCidrs() == null)
            return false;
        if (other.getIpamDiscoveredResourceCidrs() != null && other.getIpamDiscoveredResourceCidrs().equals(this.getIpamDiscoveredResourceCidrs()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIpamDiscoveredResourceCidrs() == null) ? 0 : getIpamDiscoveredResourceCidrs().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public GetIpamDiscoveredResourceCidrsResult clone() {
        try {
            return (GetIpamDiscoveredResourceCidrsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
