/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.Attribute;

public class AttributeJsonMarshaller {
    private static AttributeJsonMarshaller instance;

    public void marshall(Attribute attribute, StructuredJsonGenerator jsonGenerator) {
        if (attribute == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (attribute.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(attribute.getName());
            }
            if (attribute.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(attribute.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeJsonMarshaller();
        }
        return instance;
    }
}

