/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline;

import javax.annotation.Generated;

import com.amazonaws.services.deadline.model.*;

/**
 * Abstract implementation of {@code AWSDeadlineAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSDeadlineAsync extends AbstractAWSDeadline implements AWSDeadlineAsync {

    protected AbstractAWSDeadlineAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToFarmResult> associateMemberToFarmAsync(AssociateMemberToFarmRequest request) {

        return associateMemberToFarmAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToFarmResult> associateMemberToFarmAsync(AssociateMemberToFarmRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateMemberToFarmRequest, AssociateMemberToFarmResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToFleetResult> associateMemberToFleetAsync(AssociateMemberToFleetRequest request) {

        return associateMemberToFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToFleetResult> associateMemberToFleetAsync(AssociateMemberToFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateMemberToFleetRequest, AssociateMemberToFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToJobResult> associateMemberToJobAsync(AssociateMemberToJobRequest request) {

        return associateMemberToJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToJobResult> associateMemberToJobAsync(AssociateMemberToJobRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateMemberToJobRequest, AssociateMemberToJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToQueueResult> associateMemberToQueueAsync(AssociateMemberToQueueRequest request) {

        return associateMemberToQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateMemberToQueueResult> associateMemberToQueueAsync(AssociateMemberToQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateMemberToQueueRequest, AssociateMemberToQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssumeFleetRoleForReadResult> assumeFleetRoleForReadAsync(AssumeFleetRoleForReadRequest request) {

        return assumeFleetRoleForReadAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssumeFleetRoleForReadResult> assumeFleetRoleForReadAsync(AssumeFleetRoleForReadRequest request,
            com.amazonaws.handlers.AsyncHandler<AssumeFleetRoleForReadRequest, AssumeFleetRoleForReadResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssumeFleetRoleForWorkerResult> assumeFleetRoleForWorkerAsync(AssumeFleetRoleForWorkerRequest request) {

        return assumeFleetRoleForWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssumeFleetRoleForWorkerResult> assumeFleetRoleForWorkerAsync(AssumeFleetRoleForWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<AssumeFleetRoleForWorkerRequest, AssumeFleetRoleForWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssumeQueueRoleForReadResult> assumeQueueRoleForReadAsync(AssumeQueueRoleForReadRequest request) {

        return assumeQueueRoleForReadAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssumeQueueRoleForReadResult> assumeQueueRoleForReadAsync(AssumeQueueRoleForReadRequest request,
            com.amazonaws.handlers.AsyncHandler<AssumeQueueRoleForReadRequest, AssumeQueueRoleForReadResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssumeQueueRoleForUserResult> assumeQueueRoleForUserAsync(AssumeQueueRoleForUserRequest request) {

        return assumeQueueRoleForUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssumeQueueRoleForUserResult> assumeQueueRoleForUserAsync(AssumeQueueRoleForUserRequest request,
            com.amazonaws.handlers.AsyncHandler<AssumeQueueRoleForUserRequest, AssumeQueueRoleForUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssumeQueueRoleForWorkerResult> assumeQueueRoleForWorkerAsync(AssumeQueueRoleForWorkerRequest request) {

        return assumeQueueRoleForWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssumeQueueRoleForWorkerResult> assumeQueueRoleForWorkerAsync(AssumeQueueRoleForWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<AssumeQueueRoleForWorkerRequest, AssumeQueueRoleForWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchGetJobEntityResult> batchGetJobEntityAsync(BatchGetJobEntityRequest request) {

        return batchGetJobEntityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetJobEntityResult> batchGetJobEntityAsync(BatchGetJobEntityRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetJobEntityRequest, BatchGetJobEntityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CopyJobTemplateResult> copyJobTemplateAsync(CopyJobTemplateRequest request) {

        return copyJobTemplateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CopyJobTemplateResult> copyJobTemplateAsync(CopyJobTemplateRequest request,
            com.amazonaws.handlers.AsyncHandler<CopyJobTemplateRequest, CopyJobTemplateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateBudgetResult> createBudgetAsync(CreateBudgetRequest request) {

        return createBudgetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBudgetResult> createBudgetAsync(CreateBudgetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBudgetRequest, CreateBudgetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFarmResult> createFarmAsync(CreateFarmRequest request) {

        return createFarmAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFarmResult> createFarmAsync(CreateFarmRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFarmRequest, CreateFarmResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request) {

        return createFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateJobResult> createJobAsync(CreateJobRequest request) {

        return createJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateJobResult> createJobAsync(CreateJobRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLicenseEndpointResult> createLicenseEndpointAsync(CreateLicenseEndpointRequest request) {

        return createLicenseEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLicenseEndpointResult> createLicenseEndpointAsync(CreateLicenseEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLicenseEndpointRequest, CreateLicenseEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateMonitorResult> createMonitorAsync(CreateMonitorRequest request) {

        return createMonitorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateMonitorResult> createMonitorAsync(CreateMonitorRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateMonitorRequest, CreateMonitorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateQueueResult> createQueueAsync(CreateQueueRequest request) {

        return createQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateQueueResult> createQueueAsync(CreateQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateQueueEnvironmentResult> createQueueEnvironmentAsync(CreateQueueEnvironmentRequest request) {

        return createQueueEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateQueueEnvironmentResult> createQueueEnvironmentAsync(CreateQueueEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateQueueEnvironmentRequest, CreateQueueEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateQueueFleetAssociationResult> createQueueFleetAssociationAsync(CreateQueueFleetAssociationRequest request) {

        return createQueueFleetAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateQueueFleetAssociationResult> createQueueFleetAssociationAsync(CreateQueueFleetAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateQueueFleetAssociationRequest, CreateQueueFleetAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStorageProfileResult> createStorageProfileAsync(CreateStorageProfileRequest request) {

        return createStorageProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStorageProfileResult> createStorageProfileAsync(CreateStorageProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStorageProfileRequest, CreateStorageProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWorkerResult> createWorkerAsync(CreateWorkerRequest request) {

        return createWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWorkerResult> createWorkerAsync(CreateWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWorkerRequest, CreateWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBudgetResult> deleteBudgetAsync(DeleteBudgetRequest request) {

        return deleteBudgetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBudgetResult> deleteBudgetAsync(DeleteBudgetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBudgetRequest, DeleteBudgetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFarmResult> deleteFarmAsync(DeleteFarmRequest request) {

        return deleteFarmAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFarmResult> deleteFarmAsync(DeleteFarmRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFarmRequest, DeleteFarmResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request) {

        return deleteFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFleetRequest, DeleteFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLicenseEndpointResult> deleteLicenseEndpointAsync(DeleteLicenseEndpointRequest request) {

        return deleteLicenseEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLicenseEndpointResult> deleteLicenseEndpointAsync(DeleteLicenseEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLicenseEndpointRequest, DeleteLicenseEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteMeteredProductResult> deleteMeteredProductAsync(DeleteMeteredProductRequest request) {

        return deleteMeteredProductAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMeteredProductResult> deleteMeteredProductAsync(DeleteMeteredProductRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteMeteredProductRequest, DeleteMeteredProductResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteMonitorResult> deleteMonitorAsync(DeleteMonitorRequest request) {

        return deleteMonitorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMonitorResult> deleteMonitorAsync(DeleteMonitorRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteMonitorRequest, DeleteMonitorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest request) {

        return deleteQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteQueueRequest, DeleteQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteQueueEnvironmentResult> deleteQueueEnvironmentAsync(DeleteQueueEnvironmentRequest request) {

        return deleteQueueEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteQueueEnvironmentResult> deleteQueueEnvironmentAsync(DeleteQueueEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteQueueEnvironmentRequest, DeleteQueueEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteQueueFleetAssociationResult> deleteQueueFleetAssociationAsync(DeleteQueueFleetAssociationRequest request) {

        return deleteQueueFleetAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteQueueFleetAssociationResult> deleteQueueFleetAssociationAsync(DeleteQueueFleetAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteQueueFleetAssociationRequest, DeleteQueueFleetAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageProfileResult> deleteStorageProfileAsync(DeleteStorageProfileRequest request) {

        return deleteStorageProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageProfileResult> deleteStorageProfileAsync(DeleteStorageProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStorageProfileRequest, DeleteStorageProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkerResult> deleteWorkerAsync(DeleteWorkerRequest request) {

        return deleteWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkerResult> deleteWorkerAsync(DeleteWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWorkerRequest, DeleteWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromFarmResult> disassociateMemberFromFarmAsync(DisassociateMemberFromFarmRequest request) {

        return disassociateMemberFromFarmAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromFarmResult> disassociateMemberFromFarmAsync(DisassociateMemberFromFarmRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateMemberFromFarmRequest, DisassociateMemberFromFarmResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromFleetResult> disassociateMemberFromFleetAsync(DisassociateMemberFromFleetRequest request) {

        return disassociateMemberFromFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromFleetResult> disassociateMemberFromFleetAsync(DisassociateMemberFromFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateMemberFromFleetRequest, DisassociateMemberFromFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromJobResult> disassociateMemberFromJobAsync(DisassociateMemberFromJobRequest request) {

        return disassociateMemberFromJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromJobResult> disassociateMemberFromJobAsync(DisassociateMemberFromJobRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateMemberFromJobRequest, DisassociateMemberFromJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromQueueResult> disassociateMemberFromQueueAsync(DisassociateMemberFromQueueRequest request) {

        return disassociateMemberFromQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateMemberFromQueueResult> disassociateMemberFromQueueAsync(DisassociateMemberFromQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateMemberFromQueueRequest, DisassociateMemberFromQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBudgetResult> getBudgetAsync(GetBudgetRequest request) {

        return getBudgetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBudgetResult> getBudgetAsync(GetBudgetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBudgetRequest, GetBudgetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFarmResult> getFarmAsync(GetFarmRequest request) {

        return getFarmAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFarmResult> getFarmAsync(GetFarmRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFarmRequest, GetFarmResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFleetResult> getFleetAsync(GetFleetRequest request) {

        return getFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFleetResult> getFleetAsync(GetFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFleetRequest, GetFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetJobResult> getJobAsync(GetJobRequest request) {

        return getJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetJobResult> getJobAsync(GetJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetJobRequest, GetJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLicenseEndpointResult> getLicenseEndpointAsync(GetLicenseEndpointRequest request) {

        return getLicenseEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLicenseEndpointResult> getLicenseEndpointAsync(GetLicenseEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLicenseEndpointRequest, GetLicenseEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMonitorResult> getMonitorAsync(GetMonitorRequest request) {

        return getMonitorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMonitorResult> getMonitorAsync(GetMonitorRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMonitorRequest, GetMonitorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetQueueResult> getQueueAsync(GetQueueRequest request) {

        return getQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetQueueResult> getQueueAsync(GetQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<GetQueueRequest, GetQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetQueueEnvironmentResult> getQueueEnvironmentAsync(GetQueueEnvironmentRequest request) {

        return getQueueEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetQueueEnvironmentResult> getQueueEnvironmentAsync(GetQueueEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetQueueEnvironmentRequest, GetQueueEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetQueueFleetAssociationResult> getQueueFleetAssociationAsync(GetQueueFleetAssociationRequest request) {

        return getQueueFleetAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetQueueFleetAssociationResult> getQueueFleetAssociationAsync(GetQueueFleetAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetQueueFleetAssociationRequest, GetQueueFleetAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSessionResult> getSessionAsync(GetSessionRequest request) {

        return getSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSessionResult> getSessionAsync(GetSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSessionRequest, GetSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSessionActionResult> getSessionActionAsync(GetSessionActionRequest request) {

        return getSessionActionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSessionActionResult> getSessionActionAsync(GetSessionActionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSessionActionRequest, GetSessionActionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSessionsStatisticsAggregationResult> getSessionsStatisticsAggregationAsync(
            GetSessionsStatisticsAggregationRequest request) {

        return getSessionsStatisticsAggregationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSessionsStatisticsAggregationResult> getSessionsStatisticsAggregationAsync(
            GetSessionsStatisticsAggregationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSessionsStatisticsAggregationRequest, GetSessionsStatisticsAggregationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStepResult> getStepAsync(GetStepRequest request) {

        return getStepAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStepResult> getStepAsync(GetStepRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStepRequest, GetStepResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStorageProfileResult> getStorageProfileAsync(GetStorageProfileRequest request) {

        return getStorageProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStorageProfileResult> getStorageProfileAsync(GetStorageProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStorageProfileRequest, GetStorageProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStorageProfileForQueueResult> getStorageProfileForQueueAsync(GetStorageProfileForQueueRequest request) {

        return getStorageProfileForQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStorageProfileForQueueResult> getStorageProfileForQueueAsync(GetStorageProfileForQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStorageProfileForQueueRequest, GetStorageProfileForQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTaskResult> getTaskAsync(GetTaskRequest request) {

        return getTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTaskResult> getTaskAsync(GetTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTaskRequest, GetTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWorkerResult> getWorkerAsync(GetWorkerRequest request) {

        return getWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWorkerResult> getWorkerAsync(GetWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWorkerRequest, GetWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAvailableMeteredProductsResult> listAvailableMeteredProductsAsync(ListAvailableMeteredProductsRequest request) {

        return listAvailableMeteredProductsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAvailableMeteredProductsResult> listAvailableMeteredProductsAsync(ListAvailableMeteredProductsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAvailableMeteredProductsRequest, ListAvailableMeteredProductsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListBudgetsResult> listBudgetsAsync(ListBudgetsRequest request) {

        return listBudgetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListBudgetsResult> listBudgetsAsync(ListBudgetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListBudgetsRequest, ListBudgetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFarmMembersResult> listFarmMembersAsync(ListFarmMembersRequest request) {

        return listFarmMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFarmMembersResult> listFarmMembersAsync(ListFarmMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFarmMembersRequest, ListFarmMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFarmsResult> listFarmsAsync(ListFarmsRequest request) {

        return listFarmsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFarmsResult> listFarmsAsync(ListFarmsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFarmsRequest, ListFarmsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFleetMembersResult> listFleetMembersAsync(ListFleetMembersRequest request) {

        return listFleetMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFleetMembersResult> listFleetMembersAsync(ListFleetMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFleetMembersRequest, ListFleetMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request) {

        return listFleetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFleetsRequest, ListFleetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListJobMembersResult> listJobMembersAsync(ListJobMembersRequest request) {

        return listJobMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListJobMembersResult> listJobMembersAsync(ListJobMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListJobMembersRequest, ListJobMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {

        return listJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListJobsResult> listJobsAsync(ListJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLicenseEndpointsResult> listLicenseEndpointsAsync(ListLicenseEndpointsRequest request) {

        return listLicenseEndpointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLicenseEndpointsResult> listLicenseEndpointsAsync(ListLicenseEndpointsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLicenseEndpointsRequest, ListLicenseEndpointsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMeteredProductsResult> listMeteredProductsAsync(ListMeteredProductsRequest request) {

        return listMeteredProductsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMeteredProductsResult> listMeteredProductsAsync(ListMeteredProductsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMeteredProductsRequest, ListMeteredProductsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMonitorsResult> listMonitorsAsync(ListMonitorsRequest request) {

        return listMonitorsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMonitorsResult> listMonitorsAsync(ListMonitorsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMonitorsRequest, ListMonitorsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListQueueEnvironmentsResult> listQueueEnvironmentsAsync(ListQueueEnvironmentsRequest request) {

        return listQueueEnvironmentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListQueueEnvironmentsResult> listQueueEnvironmentsAsync(ListQueueEnvironmentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListQueueEnvironmentsRequest, ListQueueEnvironmentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListQueueFleetAssociationsResult> listQueueFleetAssociationsAsync(ListQueueFleetAssociationsRequest request) {

        return listQueueFleetAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListQueueFleetAssociationsResult> listQueueFleetAssociationsAsync(ListQueueFleetAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListQueueFleetAssociationsRequest, ListQueueFleetAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListQueueMembersResult> listQueueMembersAsync(ListQueueMembersRequest request) {

        return listQueueMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListQueueMembersResult> listQueueMembersAsync(ListQueueMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListQueueMembersRequest, ListQueueMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request) {

        return listQueuesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSessionActionsResult> listSessionActionsAsync(ListSessionActionsRequest request) {

        return listSessionActionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSessionActionsResult> listSessionActionsAsync(ListSessionActionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSessionActionsRequest, ListSessionActionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSessionsResult> listSessionsAsync(ListSessionsRequest request) {

        return listSessionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSessionsResult> listSessionsAsync(ListSessionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSessionsRequest, ListSessionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSessionsForWorkerResult> listSessionsForWorkerAsync(ListSessionsForWorkerRequest request) {

        return listSessionsForWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSessionsForWorkerResult> listSessionsForWorkerAsync(ListSessionsForWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSessionsForWorkerRequest, ListSessionsForWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStepConsumersResult> listStepConsumersAsync(ListStepConsumersRequest request) {

        return listStepConsumersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStepConsumersResult> listStepConsumersAsync(ListStepConsumersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStepConsumersRequest, ListStepConsumersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStepDependenciesResult> listStepDependenciesAsync(ListStepDependenciesRequest request) {

        return listStepDependenciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStepDependenciesResult> listStepDependenciesAsync(ListStepDependenciesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStepDependenciesRequest, ListStepDependenciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStepsResult> listStepsAsync(ListStepsRequest request) {

        return listStepsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStepsResult> listStepsAsync(ListStepsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStepsRequest, ListStepsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStorageProfilesResult> listStorageProfilesAsync(ListStorageProfilesRequest request) {

        return listStorageProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStorageProfilesResult> listStorageProfilesAsync(ListStorageProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStorageProfilesRequest, ListStorageProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStorageProfilesForQueueResult> listStorageProfilesForQueueAsync(ListStorageProfilesForQueueRequest request) {

        return listStorageProfilesForQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStorageProfilesForQueueResult> listStorageProfilesForQueueAsync(ListStorageProfilesForQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStorageProfilesForQueueRequest, ListStorageProfilesForQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTasksResult> listTasksAsync(ListTasksRequest request) {

        return listTasksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTasksResult> listTasksAsync(ListTasksRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWorkersResult> listWorkersAsync(ListWorkersRequest request) {

        return listWorkersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWorkersResult> listWorkersAsync(ListWorkersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWorkersRequest, ListWorkersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutMeteredProductResult> putMeteredProductAsync(PutMeteredProductRequest request) {

        return putMeteredProductAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutMeteredProductResult> putMeteredProductAsync(PutMeteredProductRequest request,
            com.amazonaws.handlers.AsyncHandler<PutMeteredProductRequest, PutMeteredProductResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchJobsResult> searchJobsAsync(SearchJobsRequest request) {

        return searchJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchJobsResult> searchJobsAsync(SearchJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchJobsRequest, SearchJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchStepsResult> searchStepsAsync(SearchStepsRequest request) {

        return searchStepsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchStepsResult> searchStepsAsync(SearchStepsRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchStepsRequest, SearchStepsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchTasksResult> searchTasksAsync(SearchTasksRequest request) {

        return searchTasksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchTasksResult> searchTasksAsync(SearchTasksRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchTasksRequest, SearchTasksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchWorkersResult> searchWorkersAsync(SearchWorkersRequest request) {

        return searchWorkersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchWorkersResult> searchWorkersAsync(SearchWorkersRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchWorkersRequest, SearchWorkersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartSessionsStatisticsAggregationResult> startSessionsStatisticsAggregationAsync(
            StartSessionsStatisticsAggregationRequest request) {

        return startSessionsStatisticsAggregationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartSessionsStatisticsAggregationResult> startSessionsStatisticsAggregationAsync(
            StartSessionsStatisticsAggregationRequest request,
            com.amazonaws.handlers.AsyncHandler<StartSessionsStatisticsAggregationRequest, StartSessionsStatisticsAggregationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateBudgetResult> updateBudgetAsync(UpdateBudgetRequest request) {

        return updateBudgetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateBudgetResult> updateBudgetAsync(UpdateBudgetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateBudgetRequest, UpdateBudgetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateFarmResult> updateFarmAsync(UpdateFarmRequest request) {

        return updateFarmAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateFarmResult> updateFarmAsync(UpdateFarmRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateFarmRequest, UpdateFarmResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateFleetResult> updateFleetAsync(UpdateFleetRequest request) {

        return updateFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateFleetResult> updateFleetAsync(UpdateFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateFleetRequest, UpdateFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request) {

        return updateJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateJobRequest, UpdateJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateMonitorResult> updateMonitorAsync(UpdateMonitorRequest request) {

        return updateMonitorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateMonitorResult> updateMonitorAsync(UpdateMonitorRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateMonitorRequest, UpdateMonitorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateQueueResult> updateQueueAsync(UpdateQueueRequest request) {

        return updateQueueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateQueueResult> updateQueueAsync(UpdateQueueRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateQueueRequest, UpdateQueueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateQueueEnvironmentResult> updateQueueEnvironmentAsync(UpdateQueueEnvironmentRequest request) {

        return updateQueueEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateQueueEnvironmentResult> updateQueueEnvironmentAsync(UpdateQueueEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateQueueEnvironmentRequest, UpdateQueueEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateQueueFleetAssociationResult> updateQueueFleetAssociationAsync(UpdateQueueFleetAssociationRequest request) {

        return updateQueueFleetAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateQueueFleetAssociationResult> updateQueueFleetAssociationAsync(UpdateQueueFleetAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateQueueFleetAssociationRequest, UpdateQueueFleetAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSessionResult> updateSessionAsync(UpdateSessionRequest request) {

        return updateSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSessionResult> updateSessionAsync(UpdateSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSessionRequest, UpdateSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateStepResult> updateStepAsync(UpdateStepRequest request) {

        return updateStepAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStepResult> updateStepAsync(UpdateStepRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateStepRequest, UpdateStepResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateStorageProfileResult> updateStorageProfileAsync(UpdateStorageProfileRequest request) {

        return updateStorageProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStorageProfileResult> updateStorageProfileAsync(UpdateStorageProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateStorageProfileRequest, UpdateStorageProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTaskResult> updateTaskAsync(UpdateTaskRequest request) {

        return updateTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTaskResult> updateTaskAsync(UpdateTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTaskRequest, UpdateTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerResult> updateWorkerAsync(UpdateWorkerRequest request) {

        return updateWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerResult> updateWorkerAsync(UpdateWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWorkerRequest, UpdateWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerScheduleResult> updateWorkerScheduleAsync(UpdateWorkerScheduleRequest request) {

        return updateWorkerScheduleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerScheduleResult> updateWorkerScheduleAsync(UpdateWorkerScheduleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWorkerScheduleRequest, UpdateWorkerScheduleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
