/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.util.HttpClientWrappingInputStream;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class RuntimeHttpUtils {
    private static final String COMMA = ", ";
    private static final String SPACE = " ";
    private static final String AWS_EXECUTION_ENV_PREFIX = "exec-env/";
    private static final String AWS_EXECUTION_ENV_NAME = "AWS_EXECUTION_ENV";

    public static InputStream fetchFile(URI uri, ClientConfiguration config) throws IOException {
        CloseableHttpResponse response;
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)httpClientParams, (String)RuntimeHttpUtils.getUserAgent(config, null));
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)RuntimeHttpUtils.getConnectionTimeout(config));
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)RuntimeHttpUtils.getSocketTimeout(config));
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)httpClientParams);
        if (config != null) {
            String proxyHost = config.getProxyHost();
            int proxyPort = config.getProxyPort();
            if (proxyHost != null && proxyPort > 0) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(config.getProxyUsername(), config.getProxyPassword(), config.getProxyWorkstation(), config.getProxyDomain()));
                }
            }
        }
        if ((response = httpclient.execute((HttpUriRequest)new HttpGet(uri))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uri + ": " + response);
        }
        return new HttpClientWrappingInputStream((HttpClient)httpclient, response.getEntity().getContent());
    }

    public static String getUserAgent(ClientConfiguration config, String userAgentMarker) {
        String userDefinedPrefix = config != null ? config.getUserAgentPrefix() : "";
        String userDefinedSuffix = config != null ? config.getUserAgentSuffix() : "";
        String awsExecutionEnvironment = RuntimeHttpUtils.getEnvironmentVariable(AWS_EXECUTION_ENV_NAME);
        StringBuilder userAgent = new StringBuilder(userDefinedPrefix.trim());
        if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(userDefinedPrefix)) {
            userAgent.append(COMMA).append(ClientConfiguration.DEFAULT_USER_AGENT);
        }
        if (StringUtils.hasValue(userDefinedSuffix)) {
            userAgent.append(COMMA).append(userDefinedSuffix.trim());
        }
        if (StringUtils.hasValue(awsExecutionEnvironment)) {
            userAgent.append(SPACE).append(AWS_EXECUTION_ENV_PREFIX).append(awsExecutionEnvironment.trim());
        }
        if (StringUtils.hasValue(userAgentMarker)) {
            userAgent.append(SPACE).append(userAgentMarker.trim());
        }
        return userAgent.toString();
    }

    private static String getEnvironmentVariable(String environmentVariableName) {
        try {
            return System.getenv(environmentVariableName);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static int getConnectionTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getConnectionTimeout();
        }
        return 10000;
    }

    private static int getSocketTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getSocketTimeout();
        }
        return 50000;
    }

    public static URI toUri(String endpoint, ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!endpoint.contains("://")) {
            endpoint = config.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

