/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectparticipant.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectparticipant.model.transform.ViewContentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewContent
implements Serializable,
Cloneable,
StructuredPojo {
    private String inputSchema;
    private String template;
    private List<String> actions;

    public void setInputSchema(String inputSchema) {
        this.inputSchema = inputSchema;
    }

    public String getInputSchema() {
        return this.inputSchema;
    }

    public ViewContent withInputSchema(String inputSchema) {
        this.setInputSchema(inputSchema);
        return this;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public ViewContent withTemplate(String template) {
        this.setTemplate(template);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public ViewContent withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public ViewContent withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputSchema() != null) {
            sb.append("InputSchema: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTemplate() != null) {
            sb.append("Template: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewContent)) {
            return false;
        }
        ViewContent other = (ViewContent)obj;
        if (other.getInputSchema() == null ^ this.getInputSchema() == null) {
            return false;
        }
        if (other.getInputSchema() != null && !other.getInputSchema().equals(this.getInputSchema())) {
            return false;
        }
        if (other.getTemplate() == null ^ this.getTemplate() == null) {
            return false;
        }
        if (other.getTemplate() != null && !other.getTemplate().equals(this.getTemplate())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputSchema() == null ? 0 : this.getInputSchema().hashCode());
        hashCode = 31 * hashCode + (this.getTemplate() == null ? 0 : this.getTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public ViewContent clone() {
        try {
            return (ViewContent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ViewContentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

