/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.EvaluationRule;
import com.amazonaws.services.cloudwatchevidently.model.FeatureEvaluationStrategy;
import com.amazonaws.services.cloudwatchevidently.model.FeatureStatus;
import com.amazonaws.services.cloudwatchevidently.model.Variation;
import com.amazonaws.services.cloudwatchevidently.model.VariationValueType;
import com.amazonaws.services.cloudwatchevidently.model.transform.FeatureMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Feature
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date createdTime;
    private String defaultVariation;
    private String description;
    private Map<String, String> entityOverrides;
    private List<EvaluationRule> evaluationRules;
    private String evaluationStrategy;
    private Date lastUpdatedTime;
    private String name;
    private String project;
    private String status;
    private Map<String, String> tags;
    private String valueType;
    private List<Variation> variations;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Feature withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Feature withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setDefaultVariation(String defaultVariation) {
        this.defaultVariation = defaultVariation;
    }

    public String getDefaultVariation() {
        return this.defaultVariation;
    }

    public Feature withDefaultVariation(String defaultVariation) {
        this.setDefaultVariation(defaultVariation);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Feature withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getEntityOverrides() {
        return this.entityOverrides;
    }

    public void setEntityOverrides(Map<String, String> entityOverrides) {
        this.entityOverrides = entityOverrides;
    }

    public Feature withEntityOverrides(Map<String, String> entityOverrides) {
        this.setEntityOverrides(entityOverrides);
        return this;
    }

    public Feature addEntityOverridesEntry(String key, String value) {
        if (null == this.entityOverrides) {
            this.entityOverrides = new HashMap<String, String>();
        }
        if (this.entityOverrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.entityOverrides.put(key, value);
        return this;
    }

    public Feature clearEntityOverridesEntries() {
        this.entityOverrides = null;
        return this;
    }

    public List<EvaluationRule> getEvaluationRules() {
        return this.evaluationRules;
    }

    public void setEvaluationRules(Collection<EvaluationRule> evaluationRules) {
        if (evaluationRules == null) {
            this.evaluationRules = null;
            return;
        }
        this.evaluationRules = new ArrayList<EvaluationRule>(evaluationRules);
    }

    public Feature withEvaluationRules(EvaluationRule ... evaluationRules) {
        if (this.evaluationRules == null) {
            this.setEvaluationRules(new ArrayList<EvaluationRule>(evaluationRules.length));
        }
        for (EvaluationRule ele : evaluationRules) {
            this.evaluationRules.add(ele);
        }
        return this;
    }

    public Feature withEvaluationRules(Collection<EvaluationRule> evaluationRules) {
        this.setEvaluationRules(evaluationRules);
        return this;
    }

    public void setEvaluationStrategy(String evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy;
    }

    public String getEvaluationStrategy() {
        return this.evaluationStrategy;
    }

    public Feature withEvaluationStrategy(String evaluationStrategy) {
        this.setEvaluationStrategy(evaluationStrategy);
        return this;
    }

    public Feature withEvaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy.toString();
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Feature withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Feature withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public Feature withProject(String project) {
        this.setProject(project);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Feature withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Feature withStatus(FeatureStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Feature withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Feature addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Feature clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public Feature withValueType(String valueType) {
        this.setValueType(valueType);
        return this;
    }

    public Feature withValueType(VariationValueType valueType) {
        this.valueType = valueType.toString();
        return this;
    }

    public List<Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(Collection<Variation> variations) {
        if (variations == null) {
            this.variations = null;
            return;
        }
        this.variations = new ArrayList<Variation>(variations);
    }

    public Feature withVariations(Variation ... variations) {
        if (this.variations == null) {
            this.setVariations(new ArrayList<Variation>(variations.length));
        }
        for (Variation ele : variations) {
            this.variations.add(ele);
        }
        return this;
    }

    public Feature withVariations(Collection<Variation> variations) {
        this.setVariations(variations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getDefaultVariation() != null) {
            sb.append("DefaultVariation: ").append(this.getDefaultVariation()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEntityOverrides() != null) {
            sb.append("EntityOverrides: ").append(this.getEntityOverrides()).append(",");
        }
        if (this.getEvaluationRules() != null) {
            sb.append("EvaluationRules: ").append(this.getEvaluationRules()).append(",");
        }
        if (this.getEvaluationStrategy() != null) {
            sb.append("EvaluationStrategy: ").append(this.getEvaluationStrategy()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getValueType() != null) {
            sb.append("ValueType: ").append(this.getValueType()).append(",");
        }
        if (this.getVariations() != null) {
            sb.append("Variations: ").append(this.getVariations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getDefaultVariation() == null ^ this.getDefaultVariation() == null) {
            return false;
        }
        if (other.getDefaultVariation() != null && !other.getDefaultVariation().equals(this.getDefaultVariation())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEntityOverrides() == null ^ this.getEntityOverrides() == null) {
            return false;
        }
        if (other.getEntityOverrides() != null && !other.getEntityOverrides().equals(this.getEntityOverrides())) {
            return false;
        }
        if (other.getEvaluationRules() == null ^ this.getEvaluationRules() == null) {
            return false;
        }
        if (other.getEvaluationRules() != null && !other.getEvaluationRules().equals(this.getEvaluationRules())) {
            return false;
        }
        if (other.getEvaluationStrategy() == null ^ this.getEvaluationStrategy() == null) {
            return false;
        }
        if (other.getEvaluationStrategy() != null && !other.getEvaluationStrategy().equals(this.getEvaluationStrategy())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getValueType() == null ^ this.getValueType() == null) {
            return false;
        }
        if (other.getValueType() != null && !other.getValueType().equals(this.getValueType())) {
            return false;
        }
        if (other.getVariations() == null ^ this.getVariations() == null) {
            return false;
        }
        return other.getVariations() == null || other.getVariations().equals(this.getVariations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVariation() == null ? 0 : this.getDefaultVariation().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEntityOverrides() == null ? 0 : this.getEntityOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationRules() == null ? 0 : this.getEvaluationRules().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationStrategy() == null ? 0 : this.getEvaluationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getValueType() == null ? 0 : this.getValueType().hashCode());
        hashCode = 31 * hashCode + (this.getVariations() == null ? 0 : this.getVariations().hashCode());
        return hashCode;
    }

    public Feature clone() {
        try {
            return (Feature)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FeatureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

