/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.GeneratedTemplateResourceStatus;
import com.amazonaws.services.cloudformation.model.WarningDetail;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceDetail
implements Serializable,
Cloneable {
    private String resourceType;
    private String logicalResourceId;
    private Map<String, String> resourceIdentifier;
    private String resourceStatus;
    private String resourceStatusReason;
    private SdkInternalList<WarningDetail> warnings;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceDetail withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setLogicalResourceId(String logicalResourceId) {
        this.logicalResourceId = logicalResourceId;
    }

    public String getLogicalResourceId() {
        return this.logicalResourceId;
    }

    public ResourceDetail withLogicalResourceId(String logicalResourceId) {
        this.setLogicalResourceId(logicalResourceId);
        return this;
    }

    public Map<String, String> getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(Map<String, String> resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public ResourceDetail withResourceIdentifier(Map<String, String> resourceIdentifier) {
        this.setResourceIdentifier(resourceIdentifier);
        return this;
    }

    public ResourceDetail addResourceIdentifierEntry(String key, String value) {
        if (null == this.resourceIdentifier) {
            this.resourceIdentifier = new HashMap<String, String>();
        }
        if (this.resourceIdentifier.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.resourceIdentifier.put(key, value);
        return this;
    }

    public ResourceDetail clearResourceIdentifierEntries() {
        this.resourceIdentifier = null;
        return this;
    }

    public void setResourceStatus(String resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public String getResourceStatus() {
        return this.resourceStatus;
    }

    public ResourceDetail withResourceStatus(String resourceStatus) {
        this.setResourceStatus(resourceStatus);
        return this;
    }

    public ResourceDetail withResourceStatus(GeneratedTemplateResourceStatus resourceStatus) {
        this.resourceStatus = resourceStatus.toString();
        return this;
    }

    public void setResourceStatusReason(String resourceStatusReason) {
        this.resourceStatusReason = resourceStatusReason;
    }

    public String getResourceStatusReason() {
        return this.resourceStatusReason;
    }

    public ResourceDetail withResourceStatusReason(String resourceStatusReason) {
        this.setResourceStatusReason(resourceStatusReason);
        return this;
    }

    public List<WarningDetail> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new SdkInternalList();
        }
        return this.warnings;
    }

    public void setWarnings(Collection<WarningDetail> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        this.warnings = new SdkInternalList(warnings);
    }

    public ResourceDetail withWarnings(WarningDetail ... warnings) {
        if (this.warnings == null) {
            this.setWarnings((Collection<WarningDetail>)new SdkInternalList(warnings.length));
        }
        for (WarningDetail ele : warnings) {
            this.warnings.add((Object)ele);
        }
        return this;
    }

    public ResourceDetail withWarnings(Collection<WarningDetail> warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getLogicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.getLogicalResourceId()).append(",");
        }
        if (this.getResourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.getResourceIdentifier()).append(",");
        }
        if (this.getResourceStatus() != null) {
            sb.append("ResourceStatus: ").append(this.getResourceStatus()).append(",");
        }
        if (this.getResourceStatusReason() != null) {
            sb.append("ResourceStatusReason: ").append(this.getResourceStatusReason()).append(",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: ").append(this.getWarnings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetail)) {
            return false;
        }
        ResourceDetail other = (ResourceDetail)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getLogicalResourceId() == null ^ this.getLogicalResourceId() == null) {
            return false;
        }
        if (other.getLogicalResourceId() != null && !other.getLogicalResourceId().equals(this.getLogicalResourceId())) {
            return false;
        }
        if (other.getResourceIdentifier() == null ^ this.getResourceIdentifier() == null) {
            return false;
        }
        if (other.getResourceIdentifier() != null && !other.getResourceIdentifier().equals(this.getResourceIdentifier())) {
            return false;
        }
        if (other.getResourceStatus() == null ^ this.getResourceStatus() == null) {
            return false;
        }
        if (other.getResourceStatus() != null && !other.getResourceStatus().equals(this.getResourceStatus())) {
            return false;
        }
        if (other.getResourceStatusReason() == null ^ this.getResourceStatusReason() == null) {
            return false;
        }
        if (other.getResourceStatusReason() != null && !other.getResourceStatusReason().equals(this.getResourceStatusReason())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        return other.getWarnings() == null || other.getWarnings().equals(this.getWarnings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getLogicalResourceId() == null ? 0 : this.getLogicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifier() == null ? 0 : this.getResourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getResourceStatus() == null ? 0 : this.getResourceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getResourceStatusReason() == null ? 0 : this.getResourceStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        return hashCode;
    }

    public ResourceDetail clone() {
        try {
            return (ResourceDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

