/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.SignalResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SignalResourceRequestMarshaller
implements Marshaller<Request<SignalResourceRequest>, SignalResourceRequest> {
    public Request<SignalResourceRequest> marshall(SignalResourceRequest signalResourceRequest) {
        if (signalResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)signalResourceRequest, "AmazonCloudFormation");
        request.addParameter("Action", "SignalResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (signalResourceRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)signalResourceRequest.getStackName()));
        }
        if (signalResourceRequest.getLogicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringUtils.fromString((String)signalResourceRequest.getLogicalResourceId()));
        }
        if (signalResourceRequest.getUniqueId() != null) {
            request.addParameter("UniqueId", StringUtils.fromString((String)signalResourceRequest.getUniqueId()));
        }
        if (signalResourceRequest.getStatus() != null) {
            request.addParameter("Status", StringUtils.fromString((String)signalResourceRequest.getStatus()));
        }
        return request;
    }
}

