/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chimesdkmessaging.model.SearchField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchChannelsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String chimeBearer;
    private List<SearchField> fields;
    private Integer maxResults;
    private String nextToken;

    public void setChimeBearer(String chimeBearer) {
        this.chimeBearer = chimeBearer;
    }

    public String getChimeBearer() {
        return this.chimeBearer;
    }

    public SearchChannelsRequest withChimeBearer(String chimeBearer) {
        this.setChimeBearer(chimeBearer);
        return this;
    }

    public List<SearchField> getFields() {
        return this.fields;
    }

    public void setFields(Collection<SearchField> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<SearchField>(fields);
    }

    public SearchChannelsRequest withFields(SearchField ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<SearchField>(fields.length));
        }
        for (SearchField ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public SearchChannelsRequest withFields(Collection<SearchField> fields) {
        this.setFields(fields);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchChannelsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchChannelsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChimeBearer() != null) {
            sb.append("ChimeBearer: ").append(this.getChimeBearer()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchChannelsRequest)) {
            return false;
        }
        SearchChannelsRequest other = (SearchChannelsRequest)obj;
        if (other.getChimeBearer() == null ^ this.getChimeBearer() == null) {
            return false;
        }
        if (other.getChimeBearer() != null && !other.getChimeBearer().equals(this.getChimeBearer())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChimeBearer() == null ? 0 : this.getChimeBearer().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public SearchChannelsRequest clone() {
        return (SearchChannelsRequest)super.clone();
    }
}

