/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmediapipelines.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkmediapipelines.model.ConcatenationSink;
import com.amazonaws.services.chimesdkmediapipelines.model.ConcatenationSource;
import com.amazonaws.services.chimesdkmediapipelines.model.MediaPipelineStatus;
import com.amazonaws.services.chimesdkmediapipelines.model.transform.MediaConcatenationPipelineMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MediaConcatenationPipeline
implements Serializable,
Cloneable,
StructuredPojo {
    private String mediaPipelineId;
    private String mediaPipelineArn;
    private List<ConcatenationSource> sources;
    private List<ConcatenationSink> sinks;
    private String status;
    private Date createdTimestamp;
    private Date updatedTimestamp;

    public void setMediaPipelineId(String mediaPipelineId) {
        this.mediaPipelineId = mediaPipelineId;
    }

    public String getMediaPipelineId() {
        return this.mediaPipelineId;
    }

    public MediaConcatenationPipeline withMediaPipelineId(String mediaPipelineId) {
        this.setMediaPipelineId(mediaPipelineId);
        return this;
    }

    public void setMediaPipelineArn(String mediaPipelineArn) {
        this.mediaPipelineArn = mediaPipelineArn;
    }

    public String getMediaPipelineArn() {
        return this.mediaPipelineArn;
    }

    public MediaConcatenationPipeline withMediaPipelineArn(String mediaPipelineArn) {
        this.setMediaPipelineArn(mediaPipelineArn);
        return this;
    }

    public List<ConcatenationSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<ConcatenationSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<ConcatenationSource>(sources);
    }

    public MediaConcatenationPipeline withSources(ConcatenationSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<ConcatenationSource>(sources.length));
        }
        for (ConcatenationSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public MediaConcatenationPipeline withSources(Collection<ConcatenationSource> sources) {
        this.setSources(sources);
        return this;
    }

    public List<ConcatenationSink> getSinks() {
        return this.sinks;
    }

    public void setSinks(Collection<ConcatenationSink> sinks) {
        if (sinks == null) {
            this.sinks = null;
            return;
        }
        this.sinks = new ArrayList<ConcatenationSink>(sinks);
    }

    public MediaConcatenationPipeline withSinks(ConcatenationSink ... sinks) {
        if (this.sinks == null) {
            this.setSinks(new ArrayList<ConcatenationSink>(sinks.length));
        }
        for (ConcatenationSink ele : sinks) {
            this.sinks.add(ele);
        }
        return this;
    }

    public MediaConcatenationPipeline withSinks(Collection<ConcatenationSink> sinks) {
        this.setSinks(sinks);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public MediaConcatenationPipeline withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public MediaConcatenationPipeline withStatus(MediaPipelineStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreatedTimestamp(Date createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public MediaConcatenationPipeline withCreatedTimestamp(Date createdTimestamp) {
        this.setCreatedTimestamp(createdTimestamp);
        return this;
    }

    public void setUpdatedTimestamp(Date updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
    }

    public Date getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public MediaConcatenationPipeline withUpdatedTimestamp(Date updatedTimestamp) {
        this.setUpdatedTimestamp(updatedTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMediaPipelineId() != null) {
            sb.append("MediaPipelineId: ").append(this.getMediaPipelineId()).append(",");
        }
        if (this.getMediaPipelineArn() != null) {
            sb.append("MediaPipelineArn: ").append(this.getMediaPipelineArn()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getSinks() != null) {
            sb.append("Sinks: ").append(this.getSinks()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreatedTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.getCreatedTimestamp()).append(",");
        }
        if (this.getUpdatedTimestamp() != null) {
            sb.append("UpdatedTimestamp: ").append(this.getUpdatedTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConcatenationPipeline)) {
            return false;
        }
        MediaConcatenationPipeline other = (MediaConcatenationPipeline)obj;
        if (other.getMediaPipelineId() == null ^ this.getMediaPipelineId() == null) {
            return false;
        }
        if (other.getMediaPipelineId() != null && !other.getMediaPipelineId().equals(this.getMediaPipelineId())) {
            return false;
        }
        if (other.getMediaPipelineArn() == null ^ this.getMediaPipelineArn() == null) {
            return false;
        }
        if (other.getMediaPipelineArn() != null && !other.getMediaPipelineArn().equals(this.getMediaPipelineArn())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getSinks() == null ^ this.getSinks() == null) {
            return false;
        }
        if (other.getSinks() != null && !other.getSinks().equals(this.getSinks())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreatedTimestamp() == null ^ this.getCreatedTimestamp() == null) {
            return false;
        }
        if (other.getCreatedTimestamp() != null && !other.getCreatedTimestamp().equals(this.getCreatedTimestamp())) {
            return false;
        }
        if (other.getUpdatedTimestamp() == null ^ this.getUpdatedTimestamp() == null) {
            return false;
        }
        return other.getUpdatedTimestamp() == null || other.getUpdatedTimestamp().equals(this.getUpdatedTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMediaPipelineId() == null ? 0 : this.getMediaPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getMediaPipelineArn() == null ? 0 : this.getMediaPipelineArn().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getSinks() == null ? 0 : this.getSinks().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTimestamp() == null ? 0 : this.getCreatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedTimestamp() == null ? 0 : this.getUpdatedTimestamp().hashCode());
        return hashCode;
    }

    public MediaConcatenationPipeline clone() {
        try {
            return (MediaConcatenationPipeline)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MediaConcatenationPipelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

