/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmediapipelines.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.ConcatenationSink;
import com.amazonaws.services.chimesdkmediapipelines.model.ConcatenationSource;
import com.amazonaws.services.chimesdkmediapipelines.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMediaConcatenationPipelineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<ConcatenationSource> sources;
    private List<ConcatenationSink> sinks;
    private String clientRequestToken;
    private List<Tag> tags;

    public List<ConcatenationSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<ConcatenationSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<ConcatenationSource>(sources);
    }

    public CreateMediaConcatenationPipelineRequest withSources(ConcatenationSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<ConcatenationSource>(sources.length));
        }
        for (ConcatenationSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public CreateMediaConcatenationPipelineRequest withSources(Collection<ConcatenationSource> sources) {
        this.setSources(sources);
        return this;
    }

    public List<ConcatenationSink> getSinks() {
        return this.sinks;
    }

    public void setSinks(Collection<ConcatenationSink> sinks) {
        if (sinks == null) {
            this.sinks = null;
            return;
        }
        this.sinks = new ArrayList<ConcatenationSink>(sinks);
    }

    public CreateMediaConcatenationPipelineRequest withSinks(ConcatenationSink ... sinks) {
        if (this.sinks == null) {
            this.setSinks(new ArrayList<ConcatenationSink>(sinks.length));
        }
        for (ConcatenationSink ele : sinks) {
            this.sinks.add(ele);
        }
        return this;
    }

    public CreateMediaConcatenationPipelineRequest withSinks(Collection<ConcatenationSink> sinks) {
        this.setSinks(sinks);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateMediaConcatenationPipelineRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateMediaConcatenationPipelineRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateMediaConcatenationPipelineRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getSinks() != null) {
            sb.append("Sinks: ").append(this.getSinks()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaConcatenationPipelineRequest)) {
            return false;
        }
        CreateMediaConcatenationPipelineRequest other = (CreateMediaConcatenationPipelineRequest)obj;
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getSinks() == null ^ this.getSinks() == null) {
            return false;
        }
        if (other.getSinks() != null && !other.getSinks().equals(this.getSinks())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getSinks() == null ? 0 : this.getSinks().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateMediaConcatenationPipelineRequest clone() {
        return (CreateMediaConcatenationPipelineRequest)super.clone();
    }
}

