/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Application Auto Scaling is a general purpose Auto Scaling service for supported elastic AWS resources. With
 * Application Auto Scaling, you can automatically scale your AWS resources, with an experience similar to that of Auto
 * Scaling.
 * </p>
 * <p>
 * Application Auto Scaling supports scaling the following AWS resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon ECS services
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon EC2 Spot fleet instances
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can use Application Auto Scaling to accomplish the following tasks:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Define scaling policies for automatically adjusting your AWS resources
 * </p>
 * </li>
 * <li>
 * <p>
 * Scale your resources in response to CloudWatch alarms
 * </p>
 * </li>
 * <li>
 * <p>
 * View history of your scaling events
 * </p>
 * </li>
 * </ul>
 * <p>
 * Application Auto Scaling is available in the following regions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>us-east-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>us-west-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>us-west-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ap-southeast-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ap-southeast-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ap-northeast-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>eu-central-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>eu-west-1</code>
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.applicationautoscaling;

