/*
 * Quasar: lightweight threads and actors for the JVM.
 * Copyright (c) 2013-2014, Parallel Universe Software Co. All rights reserved.
 * 
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *  
 *   or (per the licensee's choosing)
 *  
 * under the terms of the GNU Lesser General Public License version 3.0
 * as published by the Free Software Foundation.
 */
package co.paralleluniverse.actors;

/**
 * An exception that is generated by an actor's {@link Actor#handleLifecycleMessage(LifecycleMessage) handleLifecycle} method (and thrown by
 * the {@link Actor#receive() receive} method) if an {@link ExitMessage} is received from a {@link Actor#link(ActorRef) linked actor}.
 *
 * @author pron
 */
public class LifecycleException extends RuntimeException {
    private final LifecycleMessage message;

    public LifecycleException(LifecycleMessage message) {
        this.message = message;
    }

    public LifecycleMessage message() {
        return message;
    }

    @Override
    public String toString() {
        String s = getClass().getName();
        return (message != null) ? (s + ": " + message) : s;
    }
}
