/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DeploymentState;
import co.elastic.clients.elasticsearch.ml.TrainedModelDeploymentAllocationStatus;
import co.elastic.clients.elasticsearch.ml.TrainedModelDeploymentNodesStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelDeploymentStats
implements JsonpSerializable {
    private final TrainedModelDeploymentAllocationStatus allocationStatus;
    private final int errorCount;
    private final int inferenceCount;
    private final String modelId;
    private final TrainedModelDeploymentNodesStats nodes;
    private final int numberOfAllocations;
    private final int queueCapacity;
    private final int rejectedExecutionCount;
    private final String reason;
    private final long startTime;
    private final DeploymentState state;
    private final int threadsPerAllocation;
    private final int timeoutCount;
    public static final JsonpDeserializer<TrainedModelDeploymentStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelDeploymentStats::setupTrainedModelDeploymentStatsDeserializer);

    private TrainedModelDeploymentStats(Builder builder) {
        this.allocationStatus = ApiTypeHelper.requireNonNull(builder.allocationStatus, this, "allocationStatus");
        this.errorCount = ApiTypeHelper.requireNonNull(builder.errorCount, this, "errorCount");
        this.inferenceCount = ApiTypeHelper.requireNonNull(builder.inferenceCount, this, "inferenceCount");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.nodes = ApiTypeHelper.requireNonNull(builder.nodes, this, "nodes");
        this.numberOfAllocations = ApiTypeHelper.requireNonNull(builder.numberOfAllocations, this, "numberOfAllocations");
        this.queueCapacity = ApiTypeHelper.requireNonNull(builder.queueCapacity, this, "queueCapacity");
        this.rejectedExecutionCount = ApiTypeHelper.requireNonNull(builder.rejectedExecutionCount, this, "rejectedExecutionCount");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, this, "startTime");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.threadsPerAllocation = ApiTypeHelper.requireNonNull(builder.threadsPerAllocation, this, "threadsPerAllocation");
        this.timeoutCount = ApiTypeHelper.requireNonNull(builder.timeoutCount, this, "timeoutCount");
    }

    public static TrainedModelDeploymentStats of(Function<Builder, ObjectBuilder<TrainedModelDeploymentStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final TrainedModelDeploymentAllocationStatus allocationStatus() {
        return this.allocationStatus;
    }

    public final int errorCount() {
        return this.errorCount;
    }

    public final int inferenceCount() {
        return this.inferenceCount;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final TrainedModelDeploymentNodesStats nodes() {
        return this.nodes;
    }

    public final int numberOfAllocations() {
        return this.numberOfAllocations;
    }

    public final int queueCapacity() {
        return this.queueCapacity;
    }

    public final int rejectedExecutionCount() {
        return this.rejectedExecutionCount;
    }

    public final String reason() {
        return this.reason;
    }

    public final long startTime() {
        return this.startTime;
    }

    public final DeploymentState state() {
        return this.state;
    }

    public final int threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    public final int timeoutCount() {
        return this.timeoutCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation_status");
        this.allocationStatus.serialize(generator, mapper);
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        generator.writeKey("inference_count");
        generator.write(this.inferenceCount);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("nodes");
        this.nodes.serialize(generator, mapper);
        generator.writeKey("number_of_allocations");
        generator.write(this.numberOfAllocations);
        generator.writeKey("queue_capacity");
        generator.write(this.queueCapacity);
        generator.writeKey("rejected_execution_count");
        generator.write(this.rejectedExecutionCount);
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("start_time");
        generator.write(this.startTime);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("threads_per_allocation");
        generator.write(this.threadsPerAllocation);
        generator.writeKey("timeout_count");
        generator.write(this.timeoutCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelDeploymentStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocationStatus, TrainedModelDeploymentAllocationStatus._DESERIALIZER, "allocation_status");
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.integerDeserializer(), "inference_count");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::nodes, TrainedModelDeploymentNodesStats._DESERIALIZER, "nodes");
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
        op.add(Builder::queueCapacity, JsonpDeserializer.integerDeserializer(), "queue_capacity");
        op.add(Builder::rejectedExecutionCount, JsonpDeserializer.integerDeserializer(), "rejected_execution_count");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::startTime, JsonpDeserializer.longDeserializer(), "start_time");
        op.add(Builder::state, DeploymentState._DESERIALIZER, "state");
        op.add(Builder::threadsPerAllocation, JsonpDeserializer.integerDeserializer(), "threads_per_allocation");
        op.add(Builder::timeoutCount, JsonpDeserializer.integerDeserializer(), "timeout_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelDeploymentStats> {
        private TrainedModelDeploymentAllocationStatus allocationStatus;
        private Integer errorCount;
        private Integer inferenceCount;
        private String modelId;
        private TrainedModelDeploymentNodesStats nodes;
        private Integer numberOfAllocations;
        private Integer queueCapacity;
        private Integer rejectedExecutionCount;
        private String reason;
        private Long startTime;
        private DeploymentState state;
        private Integer threadsPerAllocation;
        private Integer timeoutCount;

        public final Builder allocationStatus(TrainedModelDeploymentAllocationStatus value) {
            this.allocationStatus = value;
            return this;
        }

        public final Builder allocationStatus(Function<TrainedModelDeploymentAllocationStatus.Builder, ObjectBuilder<TrainedModelDeploymentAllocationStatus>> fn) {
            return this.allocationStatus(fn.apply(new TrainedModelDeploymentAllocationStatus.Builder()).build());
        }

        public final Builder errorCount(int value) {
            this.errorCount = value;
            return this;
        }

        public final Builder inferenceCount(int value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder nodes(TrainedModelDeploymentNodesStats value) {
            this.nodes = value;
            return this;
        }

        public final Builder nodes(Function<TrainedModelDeploymentNodesStats.Builder, ObjectBuilder<TrainedModelDeploymentNodesStats>> fn) {
            return this.nodes(fn.apply(new TrainedModelDeploymentNodesStats.Builder()).build());
        }

        public final Builder numberOfAllocations(int value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder queueCapacity(int value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder rejectedExecutionCount(int value) {
            this.rejectedExecutionCount = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder startTime(long value) {
            this.startTime = value;
            return this;
        }

        public final Builder state(DeploymentState value) {
            this.state = value;
            return this;
        }

        public final Builder threadsPerAllocation(int value) {
            this.threadsPerAllocation = value;
            return this;
        }

        public final Builder timeoutCount(int value) {
            this.timeoutCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelDeploymentStats build() {
            this._checkSingleUse();
            return new TrainedModelDeploymentStats(this);
        }
    }
}

