/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NerInferenceOptions
implements InferenceConfigCreateVariant,
JsonpSerializable {
    @Nullable
    private final TokenizationConfig tokenization;
    @Nullable
    private final String resultsField;
    private final List<String> classificationLabels;
    public static final JsonpDeserializer<NerInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NerInferenceOptions::setupNerInferenceOptionsDeserializer);

    private NerInferenceOptions(Builder builder) {
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
        this.classificationLabels = ApiTypeHelper.unmodifiable(builder.classificationLabels);
    }

    public static NerInferenceOptions of(Function<Builder, ObjectBuilder<NerInferenceOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigCreate.Kind _inferenceConfigCreateKind() {
        return InferenceConfigCreate.Kind.Ner;
    }

    @Nullable
    public final TokenizationConfig tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    public final List<String> classificationLabels() {
        return this.classificationLabels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (ApiTypeHelper.isDefined(this.classificationLabels)) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String item0 : this.classificationLabels) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNerInferenceOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tokenization, TokenizationConfig._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NerInferenceOptions> {
        @Nullable
        private TokenizationConfig tokenization;
        @Nullable
        private String resultsField;
        @Nullable
        private List<String> classificationLabels;

        public final Builder tokenization(@Nullable TokenizationConfig value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<TokenizationConfig.Builder, ObjectBuilder<TokenizationConfig>> fn) {
            return this.tokenization(fn.apply(new TokenizationConfig.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder classificationLabels(List<String> list) {
            this.classificationLabels = Builder._listAddAll(this.classificationLabels, list);
            return this;
        }

        public final Builder classificationLabels(String value, String ... values) {
            this.classificationLabels = Builder._listAdd(this.classificationLabels, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NerInferenceOptions build() {
            this._checkSingleUse();
            return new NerInferenceOptions(this);
        }
    }
}

