/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry;

import cn.ponfee.scheduler.common.base.DoubleListViewer;
import cn.ponfee.scheduler.common.util.GenericUtils;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.Registry;
import cn.ponfee.scheduler.registry.ServerRole;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class ServerRegistry<R extends Server, D extends Server>
implements Registry<R>,
Discovery<D> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final char separator;
    protected final ServerRole registryRole;
    protected final String registryRootPath;
    protected final ServerRole discoveryRole;
    protected final String discoveryRootPath;
    private final DiscoveryServer<D> discoveryServer;
    protected final Set<R> registered = ConcurrentHashMap.newKeySet();
    protected final AtomicBoolean close = new AtomicBoolean(false);
    protected volatile boolean closed = false;

    protected ServerRegistry(String namespace, char separator) {
        this.separator = separator;
        String prefix = ServerRegistry.prune(namespace, separator);
        this.registryRole = ServerRole.of(GenericUtils.getActualTypeArgument(this.getClass(), (int)0));
        this.registryRootPath = prefix + this.registryRole.key();
        this.discoveryRole = ServerRole.of(GenericUtils.getActualTypeArgument(this.getClass(), (int)1));
        this.discoveryRootPath = prefix + this.discoveryRole.key();
        this.discoveryServer = ServerRegistry.createDiscoveryServer(this.discoveryRole);
    }

    public abstract boolean isConnected();

    protected final void refreshDiscoveredServers(List<D> servers) {
        this.discoveryServer.refreshServers(servers);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Refreshed discovery servers: {} - {}", (Object)this.discoveryRole.name(), servers);
        }
    }

    @Override
    public List<D> getDiscoveredServers(String group) {
        return this.discoveryServer.getServers(group);
    }

    @Override
    public void close() {
        this.discoveryServer.close();
    }

    @Override
    public final ServerRole registryRole() {
        return this.registryRole;
    }

    @Override
    public final ServerRole discoveryRole() {
        return this.discoveryRole;
    }

    private static String prune(String namespace, char separator) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            return "";
        }
        if (namespace.contains(String.valueOf(separator))) {
            throw new IllegalArgumentException("Namespace cannot contains separator symbol '" + separator + "'");
        }
        return namespace.trim() + separator;
    }

    private static <S extends Server, T extends Comparable<T>> List<S> sortServers(List<S> servers, Function<S, T> sortMapper) {
        if (CollectionUtils.isEmpty(servers)) {
            return Collections.emptyList();
        }
        servers.sort(Comparator.comparing(sortMapper::apply));
        return Collections.unmodifiableList(servers);
    }

    private static <S extends Server> DiscoveryServer<S> createDiscoveryServer(ServerRole discoveryRole) {
        switch (discoveryRole) {
            case WORKER: {
                return new DiscoveryWorker();
            }
            case SUPERVISOR: {
                return new DiscoverySupervisor();
            }
        }
        throw new UnsupportedOperationException("Unsupported discovery server '" + discoveryRole.name() + "'");
    }

    private static final class DiscoveryWorker
    extends DiscoveryServer<Worker> {
        private volatile Map<String, List<Worker>> groupedWorkers = Collections.emptyMap();
        private volatile List<Worker> allWorkers = Collections.emptyList();

        private DiscoveryWorker() {
        }

        @Override
        List<Worker> getServers(String group) {
            return group == null ? this.allWorkers : this.groupedWorkers.get(group);
        }

        @Override
        void refreshServers(List<Worker> discoveredWorkers) {
            DoubleListViewer list;
            Map<Object, Object> map;
            if (CollectionUtils.isEmpty(discoveredWorkers)) {
                map = Collections.emptyMap();
                list = Collections.emptyList();
            } else {
                map = discoveredWorkers.stream().collect(Collectors.groupingBy(Worker::getGroup)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ServerRegistry.sortServers((List)e.getValue(), Worker::getInstanceId)));
                list = new DoubleListViewer(map.values());
            }
            this.groupedWorkers = map;
            this.allWorkers = list;
        }

        @Override
        void close() {
            this.groupedWorkers = null;
            this.allWorkers = null;
        }
    }

    private static final class DiscoverySupervisor
    extends DiscoveryServer<Supervisor> {
        private volatile List<Supervisor> supervisors = Collections.emptyList();

        private DiscoverySupervisor() {
        }

        @Override
        List<Supervisor> getServers(String group) {
            Assert.isNull((Object)group, (String)("Supervisor not support group, the group argument expect null, but actual is '" + group + "'."));
            return this.supervisors;
        }

        @Override
        void refreshServers(List<Supervisor> servers) {
            this.supervisors = ServerRegistry.sortServers(servers, Server::getHost);
        }

        @Override
        void close() {
            this.supervisors = null;
        }
    }

    private static abstract class DiscoveryServer<S extends Server> {
        private DiscoveryServer() {
        }

        abstract List<S> getServers(String var1);

        abstract void refreshServers(List<S> var1);

        abstract void close();
    }
}

