/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RRI_I13_AUTHORIZATION;
import ca.uhn.hl7v2.model.v23.group.RRI_I13_PROCEDURE;
import ca.uhn.hl7v2.model.v23.group.RRI_I13_PROVIDER;
import ca.uhn.hl7v2.model.v23.group.RRI_I13_RESULTS;
import ca.uhn.hl7v2.model.v23.group.RRI_I13_VISIT;
import ca.uhn.hl7v2.model.v23.segment.ACC;
import ca.uhn.hl7v2.model.v23.segment.AL1;
import ca.uhn.hl7v2.model.v23.segment.DG1;
import ca.uhn.hl7v2.model.v23.segment.DRG;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.model.v23.segment.RF1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRI_I13
extends AbstractMessage {
    public RRI_I13() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RRI_I13(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, false, false);
            this.add(RF1.class, false, false);
            this.add(RRI_I13_AUTHORIZATION.class, false, false);
            this.add(RRI_I13_PROVIDER.class, true, true);
            this.add(PID.class, true, false);
            this.add(ACC.class, false, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RRI_I13_PROCEDURE.class, false, true);
            this.add(RRI_I13_RESULTS.class, false, true);
            this.add(RRI_I13_VISIT.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRI_I13 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public RF1 getRF1() {
        return (RF1)this.getTyped("RF1", RF1.class);
    }

    public RRI_I13_AUTHORIZATION getAUTHORIZATION() {
        return (RRI_I13_AUTHORIZATION)this.getTyped("AUTHORIZATION", RRI_I13_AUTHORIZATION.class);
    }

    public RRI_I13_PROVIDER getPROVIDER() {
        return (RRI_I13_PROVIDER)this.getTyped("PROVIDER", RRI_I13_PROVIDER.class);
    }

    public RRI_I13_PROVIDER getPROVIDER(int rep) {
        return (RRI_I13_PROVIDER)this.getTyped("PROVIDER", rep, RRI_I13_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RRI_I13_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RRI_I13_PROVIDER.class);
    }

    public void insertPROVIDER(RRI_I13_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", (Structure)structure, rep);
    }

    public RRI_I13_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RRI_I13_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RRI_I13_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RRI_I13_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public ACC getACC() {
        return (ACC)this.getTyped("ACC", ACC.class);
    }

    public DG1 getDG1() {
        return (DG1)this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return (DG1)this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return (DRG)this.getTyped("DRG", DRG.class);
    }

    public DRG getDRG(int rep) {
        return (DRG)this.getTyped("DRG", rep, DRG.class);
    }

    public int getDRGReps() {
        return this.getReps("DRG");
    }

    public List<DRG> getDRGAll() throws HL7Exception {
        return this.getAllAsList("DRG", DRG.class);
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", (Structure)structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        return (AL1)this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return (AL1)this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RRI_I13_PROCEDURE getPROCEDURE() {
        return (RRI_I13_PROCEDURE)this.getTyped("PROCEDURE", RRI_I13_PROCEDURE.class);
    }

    public RRI_I13_PROCEDURE getPROCEDURE(int rep) {
        return (RRI_I13_PROCEDURE)this.getTyped("PROCEDURE", rep, RRI_I13_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<RRI_I13_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", RRI_I13_PROCEDURE.class);
    }

    public void insertPROCEDURE(RRI_I13_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public RRI_I13_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (RRI_I13_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public RRI_I13_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (RRI_I13_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public RRI_I13_RESULTS getRESULTS() {
        return (RRI_I13_RESULTS)this.getTyped("RESULTS", RRI_I13_RESULTS.class);
    }

    public RRI_I13_RESULTS getRESULTS(int rep) {
        return (RRI_I13_RESULTS)this.getTyped("RESULTS", rep, RRI_I13_RESULTS.class);
    }

    public int getRESULTSReps() {
        return this.getReps("RESULTS");
    }

    public List<RRI_I13_RESULTS> getRESULTSAll() throws HL7Exception {
        return this.getAllAsList("RESULTS", RRI_I13_RESULTS.class);
    }

    public void insertRESULTS(RRI_I13_RESULTS structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS", (Structure)structure, rep);
    }

    public RRI_I13_RESULTS insertRESULTS(int rep) throws HL7Exception {
        return (RRI_I13_RESULTS)super.insertRepetition("RESULTS", rep);
    }

    public RRI_I13_RESULTS removeRESULTS(int rep) throws HL7Exception {
        return (RRI_I13_RESULTS)super.removeRepetition("RESULTS", rep);
    }

    public RRI_I13_VISIT getVISIT() {
        return (RRI_I13_VISIT)this.getTyped("VISIT", RRI_I13_VISIT.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

