/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_OBSERVATION;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RQA_I09_RESULTS
extends AbstractGroup {
    public RQA_I09_RESULTS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RQA_I09_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RQA_I09_RESULTS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RQA_I09_OBSERVATION getOBSERVATION() {
        RQA_I09_OBSERVATION retVal = (RQA_I09_OBSERVATION)this.getTyped("OBSERVATION", RQA_I09_OBSERVATION.class);
        return retVal;
    }

    public RQA_I09_OBSERVATION getOBSERVATION(int rep) {
        RQA_I09_OBSERVATION retVal = (RQA_I09_OBSERVATION)this.getTyped("OBSERVATION", rep, RQA_I09_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RQA_I09_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RQA_I09_OBSERVATION.class);
    }

    public void insertOBSERVATION(RQA_I09_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RQA_I09_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RQA_I09_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RQA_I09_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RQA_I09_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

