/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum PayeeTypeCodesEnum {
    SUBSCRIBER("subscriber", "http://hl7.org/fhir/payeetype"),
    PROVIDER("provider", "http://hl7.org/fhir/payeetype"),
    OTHER("other", "http://hl7.org/fhir/payeetype");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Payee Type Codes";
    private static Map<String, PayeeTypeCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, PayeeTypeCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<PayeeTypeCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static PayeeTypeCodesEnum forCode(String theCode) {
        PayeeTypeCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private PayeeTypeCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, PayeeTypeCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, PayeeTypeCodesEnum>>();
        for (PayeeTypeCodesEnum next : PayeeTypeCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<PayeeTypeCodesEnum>(){

            public String toCodeString(PayeeTypeCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(PayeeTypeCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public PayeeTypeCodesEnum fromCodeString(String theCodeString) {
                return (PayeeTypeCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public PayeeTypeCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (PayeeTypeCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

