/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Test", profile="http://hl7.org/fhir/profiles/Test", id="test")
public class Test
extends BaseResource
implements IResource {
    @Child(name="stringErr", type={StringDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<StringDt> myStringErr;
    @Child(name="stringCorr", type={StringDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<StringDt> myStringCorr;
    @Child(name="booleanErr", type={BooleanDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<BooleanDt> myBooleanErr;
    @Child(name="booleanCorr", type={BooleanDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<BooleanDt> myBooleanCorr;
    @Child(name="integerErr", type={IntegerDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<IntegerDt> myIntegerErr;
    @Child(name="integerCorr", type={IntegerDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<IntegerDt> myIntegerCorr;
    @Child(name="decimalErr", type={DecimalDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<DecimalDt> myDecimalErr;
    @Child(name="decimalCorr", type={DecimalDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<DecimalDt> myDecimalCorr;
    @Child(name="b64Err", type={Base64BinaryDt.class}, order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Base64BinaryDt> myB64Err;
    @Child(name="b64Corr", type={Base64BinaryDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Base64BinaryDt> myB64Corr;
    @Child(name="instantErr", type={InstantDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<InstantDt> myInstantErr;
    @Child(name="instantCorr", type={InstantDt.class}, order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<InstantDt> myInstantCorr;
    @Child(name="uriErr", type={UriDt.class}, order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<UriDt> myUriErr;
    @Child(name="uriCorr", type={UriDt.class}, order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<UriDt> myUriCorr;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myStringErr, this.myStringCorr, this.myBooleanErr, this.myBooleanCorr, this.myIntegerErr, this.myIntegerCorr, this.myDecimalErr, this.myDecimalCorr, this.myB64Err, this.myB64Corr, this.myInstantErr, this.myInstantCorr, this.myUriErr, this.myUriCorr});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStringErr, this.myStringCorr, this.myBooleanErr, this.myBooleanCorr, this.myIntegerErr, this.myIntegerCorr, this.myDecimalErr, this.myDecimalCorr, this.myB64Err, this.myB64Corr, this.myInstantErr, this.myInstantCorr, this.myUriErr, this.myUriCorr});
    }

    public List<StringDt> getStringErr() {
        if (this.myStringErr == null) {
            this.myStringErr = new ArrayList<StringDt>();
        }
        return this.myStringErr;
    }

    public Test setStringErr(List<StringDt> theValue) {
        this.myStringErr = theValue;
        return this;
    }

    public StringDt addStringErr() {
        StringDt newType = new StringDt();
        this.getStringErr().add(newType);
        return newType;
    }

    public Test addStringErr(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getStringErr().add(theValue);
        return this;
    }

    public StringDt getStringErrFirstRep() {
        if (this.getStringErr().isEmpty()) {
            return this.addStringErr();
        }
        return this.getStringErr().get(0);
    }

    public Test addStringErr(String theString) {
        if (this.myStringErr == null) {
            this.myStringErr = new ArrayList<StringDt>();
        }
        this.myStringErr.add(new StringDt(theString));
        return this;
    }

    public List<StringDt> getStringCorr() {
        if (this.myStringCorr == null) {
            this.myStringCorr = new ArrayList<StringDt>();
        }
        return this.myStringCorr;
    }

    public Test setStringCorr(List<StringDt> theValue) {
        this.myStringCorr = theValue;
        return this;
    }

    public StringDt addStringCorr() {
        StringDt newType = new StringDt();
        this.getStringCorr().add(newType);
        return newType;
    }

    public Test addStringCorr(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getStringCorr().add(theValue);
        return this;
    }

    public StringDt getStringCorrFirstRep() {
        if (this.getStringCorr().isEmpty()) {
            return this.addStringCorr();
        }
        return this.getStringCorr().get(0);
    }

    public Test addStringCorr(String theString) {
        if (this.myStringCorr == null) {
            this.myStringCorr = new ArrayList<StringDt>();
        }
        this.myStringCorr.add(new StringDt(theString));
        return this;
    }

    public List<BooleanDt> getBooleanErr() {
        if (this.myBooleanErr == null) {
            this.myBooleanErr = new ArrayList<BooleanDt>();
        }
        return this.myBooleanErr;
    }

    public Test setBooleanErr(List<BooleanDt> theValue) {
        this.myBooleanErr = theValue;
        return this;
    }

    public BooleanDt addBooleanErr() {
        BooleanDt newType = new BooleanDt();
        this.getBooleanErr().add(newType);
        return newType;
    }

    public Test addBooleanErr(BooleanDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getBooleanErr().add(theValue);
        return this;
    }

    public BooleanDt getBooleanErrFirstRep() {
        if (this.getBooleanErr().isEmpty()) {
            return this.addBooleanErr();
        }
        return this.getBooleanErr().get(0);
    }

    public Test addBooleanErr(boolean theBoolean) {
        if (this.myBooleanErr == null) {
            this.myBooleanErr = new ArrayList<BooleanDt>();
        }
        this.myBooleanErr.add(new BooleanDt(theBoolean));
        return this;
    }

    public List<BooleanDt> getBooleanCorr() {
        if (this.myBooleanCorr == null) {
            this.myBooleanCorr = new ArrayList<BooleanDt>();
        }
        return this.myBooleanCorr;
    }

    public Test setBooleanCorr(List<BooleanDt> theValue) {
        this.myBooleanCorr = theValue;
        return this;
    }

    public BooleanDt addBooleanCorr() {
        BooleanDt newType = new BooleanDt();
        this.getBooleanCorr().add(newType);
        return newType;
    }

    public Test addBooleanCorr(BooleanDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getBooleanCorr().add(theValue);
        return this;
    }

    public BooleanDt getBooleanCorrFirstRep() {
        if (this.getBooleanCorr().isEmpty()) {
            return this.addBooleanCorr();
        }
        return this.getBooleanCorr().get(0);
    }

    public Test addBooleanCorr(boolean theBoolean) {
        if (this.myBooleanCorr == null) {
            this.myBooleanCorr = new ArrayList<BooleanDt>();
        }
        this.myBooleanCorr.add(new BooleanDt(theBoolean));
        return this;
    }

    public List<IntegerDt> getIntegerErr() {
        if (this.myIntegerErr == null) {
            this.myIntegerErr = new ArrayList<IntegerDt>();
        }
        return this.myIntegerErr;
    }

    public Test setIntegerErr(List<IntegerDt> theValue) {
        this.myIntegerErr = theValue;
        return this;
    }

    public IntegerDt addIntegerErr() {
        IntegerDt newType = new IntegerDt();
        this.getIntegerErr().add(newType);
        return newType;
    }

    public Test addIntegerErr(IntegerDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIntegerErr().add(theValue);
        return this;
    }

    public IntegerDt getIntegerErrFirstRep() {
        if (this.getIntegerErr().isEmpty()) {
            return this.addIntegerErr();
        }
        return this.getIntegerErr().get(0);
    }

    public Test addIntegerErr(int theInteger) {
        if (this.myIntegerErr == null) {
            this.myIntegerErr = new ArrayList<IntegerDt>();
        }
        this.myIntegerErr.add(new IntegerDt(theInteger));
        return this;
    }

    public List<IntegerDt> getIntegerCorr() {
        if (this.myIntegerCorr == null) {
            this.myIntegerCorr = new ArrayList<IntegerDt>();
        }
        return this.myIntegerCorr;
    }

    public Test setIntegerCorr(List<IntegerDt> theValue) {
        this.myIntegerCorr = theValue;
        return this;
    }

    public IntegerDt addIntegerCorr() {
        IntegerDt newType = new IntegerDt();
        this.getIntegerCorr().add(newType);
        return newType;
    }

    public Test addIntegerCorr(IntegerDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIntegerCorr().add(theValue);
        return this;
    }

    public IntegerDt getIntegerCorrFirstRep() {
        if (this.getIntegerCorr().isEmpty()) {
            return this.addIntegerCorr();
        }
        return this.getIntegerCorr().get(0);
    }

    public Test addIntegerCorr(int theInteger) {
        if (this.myIntegerCorr == null) {
            this.myIntegerCorr = new ArrayList<IntegerDt>();
        }
        this.myIntegerCorr.add(new IntegerDt(theInteger));
        return this;
    }

    public List<DecimalDt> getDecimalErr() {
        if (this.myDecimalErr == null) {
            this.myDecimalErr = new ArrayList<DecimalDt>();
        }
        return this.myDecimalErr;
    }

    public Test setDecimalErr(List<DecimalDt> theValue) {
        this.myDecimalErr = theValue;
        return this;
    }

    public DecimalDt addDecimalErr() {
        DecimalDt newType = new DecimalDt();
        this.getDecimalErr().add(newType);
        return newType;
    }

    public Test addDecimalErr(DecimalDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDecimalErr().add(theValue);
        return this;
    }

    public DecimalDt getDecimalErrFirstRep() {
        if (this.getDecimalErr().isEmpty()) {
            return this.addDecimalErr();
        }
        return this.getDecimalErr().get(0);
    }

    public Test addDecimalErr(long theValue) {
        if (this.myDecimalErr == null) {
            this.myDecimalErr = new ArrayList<DecimalDt>();
        }
        this.myDecimalErr.add(new DecimalDt(theValue));
        return this;
    }

    public Test addDecimalErr(double theValue) {
        if (this.myDecimalErr == null) {
            this.myDecimalErr = new ArrayList<DecimalDt>();
        }
        this.myDecimalErr.add(new DecimalDt(theValue));
        return this;
    }

    public Test addDecimalErr(BigDecimal theValue) {
        if (this.myDecimalErr == null) {
            this.myDecimalErr = new ArrayList<DecimalDt>();
        }
        this.myDecimalErr.add(new DecimalDt(theValue));
        return this;
    }

    public List<DecimalDt> getDecimalCorr() {
        if (this.myDecimalCorr == null) {
            this.myDecimalCorr = new ArrayList<DecimalDt>();
        }
        return this.myDecimalCorr;
    }

    public Test setDecimalCorr(List<DecimalDt> theValue) {
        this.myDecimalCorr = theValue;
        return this;
    }

    public DecimalDt addDecimalCorr() {
        DecimalDt newType = new DecimalDt();
        this.getDecimalCorr().add(newType);
        return newType;
    }

    public Test addDecimalCorr(DecimalDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDecimalCorr().add(theValue);
        return this;
    }

    public DecimalDt getDecimalCorrFirstRep() {
        if (this.getDecimalCorr().isEmpty()) {
            return this.addDecimalCorr();
        }
        return this.getDecimalCorr().get(0);
    }

    public Test addDecimalCorr(long theValue) {
        if (this.myDecimalCorr == null) {
            this.myDecimalCorr = new ArrayList<DecimalDt>();
        }
        this.myDecimalCorr.add(new DecimalDt(theValue));
        return this;
    }

    public Test addDecimalCorr(double theValue) {
        if (this.myDecimalCorr == null) {
            this.myDecimalCorr = new ArrayList<DecimalDt>();
        }
        this.myDecimalCorr.add(new DecimalDt(theValue));
        return this;
    }

    public Test addDecimalCorr(BigDecimal theValue) {
        if (this.myDecimalCorr == null) {
            this.myDecimalCorr = new ArrayList<DecimalDt>();
        }
        this.myDecimalCorr.add(new DecimalDt(theValue));
        return this;
    }

    public List<Base64BinaryDt> getB64Err() {
        if (this.myB64Err == null) {
            this.myB64Err = new ArrayList<Base64BinaryDt>();
        }
        return this.myB64Err;
    }

    public Test setB64Err(List<Base64BinaryDt> theValue) {
        this.myB64Err = theValue;
        return this;
    }

    public Base64BinaryDt addB64Err() {
        Base64BinaryDt newType = new Base64BinaryDt();
        this.getB64Err().add(newType);
        return newType;
    }

    public Test addB64Err(Base64BinaryDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getB64Err().add(theValue);
        return this;
    }

    public Base64BinaryDt getB64ErrFirstRep() {
        if (this.getB64Err().isEmpty()) {
            return this.addB64Err();
        }
        return this.getB64Err().get(0);
    }

    public Test addB64Err(byte[] theBytes) {
        if (this.myB64Err == null) {
            this.myB64Err = new ArrayList<Base64BinaryDt>();
        }
        this.myB64Err.add(new Base64BinaryDt(theBytes));
        return this;
    }

    public List<Base64BinaryDt> getB64Corr() {
        if (this.myB64Corr == null) {
            this.myB64Corr = new ArrayList<Base64BinaryDt>();
        }
        return this.myB64Corr;
    }

    public Test setB64Corr(List<Base64BinaryDt> theValue) {
        this.myB64Corr = theValue;
        return this;
    }

    public Base64BinaryDt addB64Corr() {
        Base64BinaryDt newType = new Base64BinaryDt();
        this.getB64Corr().add(newType);
        return newType;
    }

    public Test addB64Corr(Base64BinaryDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getB64Corr().add(theValue);
        return this;
    }

    public Base64BinaryDt getB64CorrFirstRep() {
        if (this.getB64Corr().isEmpty()) {
            return this.addB64Corr();
        }
        return this.getB64Corr().get(0);
    }

    public Test addB64Corr(byte[] theBytes) {
        if (this.myB64Corr == null) {
            this.myB64Corr = new ArrayList<Base64BinaryDt>();
        }
        this.myB64Corr.add(new Base64BinaryDt(theBytes));
        return this;
    }

    public List<InstantDt> getInstantErr() {
        if (this.myInstantErr == null) {
            this.myInstantErr = new ArrayList<InstantDt>();
        }
        return this.myInstantErr;
    }

    public Test setInstantErr(List<InstantDt> theValue) {
        this.myInstantErr = theValue;
        return this;
    }

    public InstantDt addInstantErr() {
        InstantDt newType = new InstantDt();
        this.getInstantErr().add(newType);
        return newType;
    }

    public Test addInstantErr(InstantDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getInstantErr().add(theValue);
        return this;
    }

    public InstantDt getInstantErrFirstRep() {
        if (this.getInstantErr().isEmpty()) {
            return this.addInstantErr();
        }
        return this.getInstantErr().get(0);
    }

    public Test addInstantErr(Date theDate) {
        if (this.myInstantErr == null) {
            this.myInstantErr = new ArrayList<InstantDt>();
        }
        this.myInstantErr.add(new InstantDt(theDate));
        return this;
    }

    public Test addInstantErr(Date theDate, TemporalPrecisionEnum thePrecision) {
        if (this.myInstantErr == null) {
            this.myInstantErr = new ArrayList<InstantDt>();
        }
        this.myInstantErr.add(new InstantDt(theDate, thePrecision));
        return this;
    }

    public List<InstantDt> getInstantCorr() {
        if (this.myInstantCorr == null) {
            this.myInstantCorr = new ArrayList<InstantDt>();
        }
        return this.myInstantCorr;
    }

    public Test setInstantCorr(List<InstantDt> theValue) {
        this.myInstantCorr = theValue;
        return this;
    }

    public InstantDt addInstantCorr() {
        InstantDt newType = new InstantDt();
        this.getInstantCorr().add(newType);
        return newType;
    }

    public Test addInstantCorr(InstantDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getInstantCorr().add(theValue);
        return this;
    }

    public InstantDt getInstantCorrFirstRep() {
        if (this.getInstantCorr().isEmpty()) {
            return this.addInstantCorr();
        }
        return this.getInstantCorr().get(0);
    }

    public Test addInstantCorr(Date theDate) {
        if (this.myInstantCorr == null) {
            this.myInstantCorr = new ArrayList<InstantDt>();
        }
        this.myInstantCorr.add(new InstantDt(theDate));
        return this;
    }

    public Test addInstantCorr(Date theDate, TemporalPrecisionEnum thePrecision) {
        if (this.myInstantCorr == null) {
            this.myInstantCorr = new ArrayList<InstantDt>();
        }
        this.myInstantCorr.add(new InstantDt(theDate, thePrecision));
        return this;
    }

    public List<UriDt> getUriErr() {
        if (this.myUriErr == null) {
            this.myUriErr = new ArrayList<UriDt>();
        }
        return this.myUriErr;
    }

    public Test setUriErr(List<UriDt> theValue) {
        this.myUriErr = theValue;
        return this;
    }

    public UriDt addUriErr() {
        UriDt newType = new UriDt();
        this.getUriErr().add(newType);
        return newType;
    }

    public Test addUriErr(UriDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUriErr().add(theValue);
        return this;
    }

    public UriDt getUriErrFirstRep() {
        if (this.getUriErr().isEmpty()) {
            return this.addUriErr();
        }
        return this.getUriErr().get(0);
    }

    public Test addUriErr(String theUri) {
        if (this.myUriErr == null) {
            this.myUriErr = new ArrayList<UriDt>();
        }
        this.myUriErr.add(new UriDt(theUri));
        return this;
    }

    public List<UriDt> getUriCorr() {
        if (this.myUriCorr == null) {
            this.myUriCorr = new ArrayList<UriDt>();
        }
        return this.myUriCorr;
    }

    public Test setUriCorr(List<UriDt> theValue) {
        this.myUriCorr = theValue;
        return this;
    }

    public UriDt addUriCorr() {
        UriDt newType = new UriDt();
        this.getUriCorr().add(newType);
        return newType;
    }

    public Test addUriCorr(UriDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUriCorr().add(theValue);
        return this;
    }

    public UriDt getUriCorrFirstRep() {
        if (this.getUriCorr().isEmpty()) {
            return this.addUriCorr();
        }
        return this.getUriCorr().get(0);
    }

    public Test addUriCorr(String theUri) {
        if (this.myUriCorr == null) {
            this.myUriCorr = new ArrayList<UriDt>();
        }
        this.myUriCorr.add(new UriDt(theUri));
        return this;
    }

    public String getResourceName() {
        return "Test";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

