package org.nuiton.topia.taas.entities;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;

public interface TaasPrincipal extends TopiaEntity {

    String NAME = "name";

    String AUTHORIZATIONS = "authorizations";

    void setName(String name);

    String getName();

    void addAuthorizations(TaasAuthorization authorizations);

    void addAllAuthorizations(Collection<TaasAuthorization> authorizations);

    void setAuthorizations(Collection<TaasAuthorization> authorizations);

    void removeAuthorizations(TaasAuthorization authorizations);

    void clearAuthorizations();

    Collection<TaasAuthorization> getAuthorizations();

    TaasAuthorization getAuthorizationsByTopiaId(String topiaId);

    int sizeAuthorizations();

    boolean isAuthorizationsEmpty();

} //TaasPrincipal
