/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model.io.xpp3.api;

import com.google.common.base.Function;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.jredmine.model.io.xpp3.api.DataConverter;

public abstract class PropertyMapper {
    private static final Log log = LogFactory.getLog(PropertyMapper.class);
    protected final String name;
    protected final String propertyName;
    protected final DataConverter type;
    protected final Class<?> containerType;
    protected final PropertyDescriptor descriptor;
    protected final boolean onlyOne;
    public static final Function<String, String> TAG_NAME_TRANSFORMER = new Function<String, String>(){

        public String apply(String input) {
            int i;
            String[] parts = input.split("-");
            StringBuilder buffer = new StringBuilder();
            int j = parts.length;
            for (i = 0; i < j; ++i) {
                if (i == 0) {
                    buffer.append(parts[i]);
                    continue;
                }
                buffer.append(StringUtils.capitalize((String)parts[i]));
            }
            parts = buffer.toString().split("_");
            buffer = new StringBuilder();
            j = parts.length;
            for (i = 0; i < j; ++i) {
                if (i == 0) {
                    buffer.append(parts[i]);
                    continue;
                }
                buffer.append(StringUtils.capitalize((String)parts[i]));
            }
            String result = buffer.toString();
            return result;
        }
    };

    protected PropertyMapper(String tagName, String propertyName, Class<?> containerType, DataConverter type, boolean onlyOne, PropertyDescriptor descriptor) {
        this.name = tagName;
        this.propertyName = propertyName;
        this.type = type;
        this.onlyOne = onlyOne;
        this.containerType = containerType;
        this.descriptor = descriptor;
    }

    protected String getXmlName() {
        return this.name;
    }

    protected abstract Object getDataFromXml(XmlPullParser var1) throws Exception;

    public void setProperty(Object src, XmlPullParser parser, Set<String> parsed, boolean strict) throws XmlPullParserException, IOException {
        if (this.onlyOne && parsed.contains(this.getXmlName())) {
            throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
        }
        parsed.add(this.getXmlName());
        try {
            Object r;
            if (log.isDebugEnabled()) {
                log.debug((Object)this.getXmlName());
            }
            if ((r = this.getDataFromXml(parser)) != null) {
                this.descriptor.getWriteMethod().invoke(src, r);
            }
        }
        catch (XmlPullParserException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            if (strict) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        catch (ParseException e) {
            if (strict) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
        }
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isOnlyOne() {
        return this.onlyOne;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getTagName() {
        return this.name;
    }

    public DataConverter getType() {
        return this.type;
    }

    public Class<?> getContainerType() {
        return this.containerType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("name", (Object)this.name);
        toStringBuilder.append("propertyName", (Object)this.propertyName);
        toStringBuilder.append("onlyOne", this.onlyOne);
        toStringBuilder.append("type", (Object)this.type);
        toStringBuilder.append("containerType", this.containerType);
        return toStringBuilder.toString();
    }

    public static String getMapperForTag(Class<?> type) {
        return type.getName() + "#";
    }

    public static String getMapperForAttribute(Class<?> type, String attributeName) {
        return type.getName() + "#" + attributeName + "#";
    }

    protected static PropertyDescriptor getDescriptor(Class<?> containerType, String propertyName) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(containerType);
        PropertyDescriptor descriptor = null;
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            descriptor = propertyDescriptor;
            break;
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("could not find a property descriptor for property " + propertyName + " of " + containerType);
        }
        return descriptor;
    }

    protected void registerMapper(Map<String, PropertyMapper> allMappers, Class<?> containerType, String tagName, String attributeName) {
        String key = attributeName == null ? PropertyMapper.getMapperForTag(containerType) + tagName : PropertyMapper.getMapperForAttribute(containerType, tagName) + attributeName;
        allMappers.put(key, this);
    }
}

