/*
 * #%L
 * JAXX :: Tutorial Config
 * 
 * $Id: RunDemo.java 2129 2010-11-18 17:26:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.5/jaxx-tutorial-config/src/main/java/jaxx/demo/config/RunDemo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.config;

import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import java.util.Arrays;
import java.util.Date;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class RunDemo {

    /** Logger */
    private static Log log = LogFactory.getLog(RunDemo.class);

    /** The singleton instance of the main context */
    protected static DefaultApplicationContext context;

    public static void main(String[] args) {

        log.info("JAXX Demo start at " + new Date() + " args: " + Arrays.toString(args));

        try {

            I18n.setInitializer(new DefaultI18nInitializer("jaxx-tutorial-config-i18n"));

            // init config
            DemoConfig config = new DemoConfig();

            // init i18n
            I18n.init(config.getLocale());

            // prepare ui look&feel and load ui properties

            try {
                SwingUtil.initNimbusLoookAndFeel();
            } catch (Exception e) {
                // could not find nimbus look-and-feel
                log.warn(_("jaxxdemo.warning.nimbus.landf"));
            } catch (Throwable e) {
                log.warn(_("jaxxdemo.warning.no.ui"));
            }

            // instanciate config helper
            ConfigUIHelper helper = new ConfigUIHelper(config);

            // build the config ui
            buildConfigUI(helper);

            // display it
            JFrame parentUI = new JFrame();
            
            helper.displayUI(parentUI, false);

            // will force quit after quitting config ui
            parentUI.dispose();

        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public static void buildConfigUI(ConfigUIHelper helper) {

        Runnable reloadUICallback = new Runnable() {

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("will say Hello world");
                }
                JOptionPane.showMessageDialog(null, "Hello World!");
            }
        };

        Runnable reloadApplicationCallback = new Runnable() {

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("will reload appplication");
                }
                if (log.isInfoEnabled()) {
                    log.info("will say Good Bye world");
                }
                JOptionPane.showMessageDialog(null, "Good Bye World!");
            }
        };

        helper.registerCallBack("ui",
                                n_("demo.action.reload.ui"),
                                SwingUtil.createActionIcon("reload-ui"),
                                reloadUICallback);

        helper.registerCallBack("application",
                                n_("demo.action.reload.application"),
                                SwingUtil.createActionIcon("reload-application"),
                                reloadApplicationCallback);

        // categorie repertoires

        helper.addCategory(n_("jaxxdemo.config.category.directories"),
                           n_("jaxxdemo.config.category.directories.description"));

        helper.addOption(DemoConfig.Option.CONFIG_FILE);

        // others
        helper.addCategory(n_("jaxxdemo.config.category.other"),
                           n_("jaxxdemo.config.category.other.description"));

        helper.addOption(DemoConfig.Option.FULL_SCREEN);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_FULLSCREEN);
        helper.setOptionCallBack("ui");

        helper.addOption(DemoConfig.Option.FONT_SIZE);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_FONT_SIZE);
        helper.setOptionCallBack("application");

        helper.addOption(DemoConfig.Option.LOCALE);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_LOCALE);
        helper.setOptionCallBack("ui");

        helper.buildUI(new JAXXInitialContext(),
                                     "jaxxdemo.config.category.other");

    }

}
