/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;

public abstract class JavaElement {
    private String name;
    private int modifiers;
    private Set<String> annotations;
    public static final Comparator<JavaElement> JavaElementComparator = new Comparator<JavaElement>(){
        final Pattern NAME_PATTERN = Pattern.compile("(.+)([0-9]+)");

        @Override
        public int compare(JavaElement o1, JavaElement o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }
    };

    public JavaElement(int modifiers, String name) {
        this.modifiers = modifiers;
        this.name = name;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getModifiersText() {
        if (this.modifiers == 0) {
            return "";
        }
        return Modifier.toString(this.modifiers) + ' ';
    }

    public Set<String> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashSet<String>();
        }
        return this.annotations;
    }

    public boolean hasAnnotations() {
        return CollectionUtils.isNotEmpty(this.annotations);
    }

    public void addAnnotation(String annotation) {
        this.getAnnotations().add(annotation);
    }
}

