/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.condorcet;

import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.impl.condorcet.CondorcetVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class CondorcetVoteCounting
extends AbstractVoteCounting {
    public CondorcetVoteCounting() {
        super(VoteCountings.Condorcet);
    }

    public CondorcetVoteCountingStrategy newStrategy() {
        return new CondorcetVoteCountingStrategy();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(1.0);
    }

    @Override
    public Multimap<String, String> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        Multimap<String, String> errorMap = super.validateVoteForChoice(voteForChoice, config, locale);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue == null) {
            errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.condorcet.voteValue.error.required", (Object[])new Object[0]));
        } else if (voteValue < 0.0) {
            errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.condorcet.voteValue.error.positive", (Object[])new Object[]{voteValue}));
        }
        return errorMap;
    }
}

