/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.utils;

import java.util.List;

/**
 * Classe utilitaire pour les algorithmes de dépouillement.
 *
 * @version $Id: Utils.java 2836 2010-01-11 12:46:59Z schorlet $
 */
public class Utils {

    public static double calculatePercentage(PercentageBehavior in,
            List<PercentageBehavior> list) {
        double total = 0.;
        for (PercentageBehavior curr : list) {
            total += curr.value();
        }
        return (in.value() / total * 100);
    }

    /**
     * Calcul le nombre de votes d'une liste
     *
     * @param list : liste d'éléments (doivent impléméntés ObjectWithList)
     * @param byGroup : condition sur le calcul
     * @return nombre de votes
     */
    public static int calculateNbVotes(List list, boolean byGroup) {
        return byGroup ? calculateNbSubElements(list) : list.size();
    }
    
    /**
     * Calcul le nombre de sous éléments d'une liste Les éléments du vecteur
     * doivent implémenter l'interface ListBehavior
     *
     * @param list : liste source
     * @return nombre de sous éléments
     */
    private static int calculateNbSubElements(List<ListBehavior<Object>> list) {
        int nbVotes = 0;
        for (ListBehavior<Object> curr : list) {
            nbVotes += curr.list().size();
        }
        return nbVotes;
    }

}