/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.services;

import java.io.File;

import org.chorem.pollen.votecounting.dto.PollExportDTO;

/**
 * Interface du service d'export.
 *
 * @author boukhary
 * @version $Id: ServiceExport.java 2867 2010-02-09 16:20:38Z jruchaud $
 */
public interface ServiceExport {

    /**
     * Export d'un sondage et de ses résultats au format XML. Le DTO contient le
     * sondage et ses résultats s'ils existent.
     *
     * @param export : DTO à exporter.
     * @return le chemin du fichier exporté.
     */
    public String executeExport(PollExportDTO export);

    /**
     * Export d'un sondage et de ses résultats au format XML. Le DTO contient le
     * sondage et ses résultats s'ils existent.
     *
     * @param export : DTO à exporter.
     * @return le fichier exporté.
     */
    public File executeFileExport(PollExportDTO export);

    /**
     * Import d'un sondage et de ses résultats à partir d'un fichier XML.
     *
     * @param filePath chemin du fichier à importer.
     * @return le sondage importé
     */
    public PollExportDTO executeImport(String filePath);
}
