/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.dto;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.votecounting.utils.ListBehavior;

/**
 * Classe DTO représentant un groupe de votants.
 *
 * @version $Id: VotingGroupDTO.java 2732 2009-08-18 12:26:50Z nrannou $
 */
public class VotingGroupDTO implements ListBehavior<VotingPersonDTO> {

    private String name;

    private double weight;

    private String idGroup;

    private List<VotingPersonDTO> votingPersons;

    public VotingGroupDTO(String idGroup, double weight) {
        this.idGroup = idGroup;
        this.weight = weight;
        this.votingPersons = new ArrayList<VotingPersonDTO>();
    }

    @Override
    public List<VotingPersonDTO> list() {
        return votingPersons;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getWeight() {
        return weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String getIdGroup() {
        return idGroup;
    }

    public void setIdGroup(String idGroup) {
        this.idGroup = idGroup;
    }

    public List<VotingPersonDTO> getVotingPersons() {
        return votingPersons;
    }

    public void setVotingPersons(List<VotingPersonDTO> votingPersons) {
        this.votingPersons = votingPersons;
    }

}