/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.strategy;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.chorem.pollen.votecounting.model.ChoiceIdAble;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategy;
import org.nuiton.i18n.I18n;

public abstract class AbstractVoteCountingStrategy
implements VoteCountingStrategy {
    public static final BigDecimal ZERO_D = BigDecimal.valueOf(0.0);

    @Override
    public String getStrategyName(Locale locale) {
        String result = I18n.l_((Locale)locale, (String)this.getI18nName(), (Object[])new Object[0]);
        return result;
    }

    @Override
    public String getStrategyHelp(Locale locale) {
        String voteName = I18n.l_((Locale)locale, (String)this.getI18nName(), (Object[])new Object[0]);
        String voteHelp = I18n.l_((Locale)locale, (String)this.getI18nHelp(), (Object[])new Object[0]);
        String result = I18n.l_((Locale)locale, (String)"pollen.voteCountingType.help", (Object[])new Object[]{voteName, voteHelp});
        return result;
    }

    public SortedMap<String, ChoiceScore> votersToResult(Set<Voter> voters) {
        Set<String> choiceIds = this.getAllChoiceIds(voters);
        TreeMap resultByChoice = Maps.newTreeMap();
        for (String choiceId : choiceIds) {
            ChoiceScore choiceScore = ChoiceScore.newScore(choiceId, null);
            resultByChoice.put(choiceId, choiceScore);
        }
        return resultByChoice;
    }

    public VoteCountingResult resultToList(Map<String, ChoiceScore> resultByChoice) {
        List<ChoiceScore> score = this.toChoiceScore(resultByChoice);
        return VoteCountingResult.newResult(score);
    }

    public List<ChoiceScore> toChoiceScore(Map<String, ChoiceScore> resultByChoice) {
        ArrayList score = Lists.newArrayList(resultByChoice.values());
        Collections.sort(score);
        Collections.reverse(score);
        return score;
    }

    public Set<String> getAllChoiceIds(Set<Voter> voters) {
        ChoiceIdAble.ChoiceIdAbleById function = new ChoiceIdAble.ChoiceIdAbleById();
        HashSet result = Sets.newHashSet();
        for (Voter voter : voters) {
            Iterable transform = Iterables.transform(voter.getVoteForChoices(), (Function)function);
            Iterables.addAll((Collection)result, (Iterable)transform);
        }
        return result;
    }

    public Map<Voter, List<Set<String>>> buildVoterSortedChoices(Set<Voter> voters) {
        VoteForChoiceComparator comparator = new VoteForChoiceComparator();
        HashMap voterSortedChoices = Maps.newHashMap();
        for (Voter voter : voters) {
            List<Set<String>> sortedChoices = this.sortVoteForChoices(voter.getVoteForChoices(), comparator);
            voterSortedChoices.put(voter, sortedChoices);
        }
        return voterSortedChoices;
    }

    public List<Set<String>> sortVoteForChoices(Set<VoteForChoice> voteForChoices, Comparator<VoteForChoice> comparator) {
        ArrayList sortedChoices = Lists.newArrayList(voteForChoices);
        Collections.sort(sortedChoices, comparator);
        ArrayList result = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        result.add(set);
        VoteForChoice lastVoteForChoice = null;
        for (VoteForChoice voteForChoice : sortedChoices) {
            if (lastVoteForChoice != null && comparator.compare(lastVoteForChoice, voteForChoice) != 0) {
                set = Sets.newHashSet();
                result.add(set);
            }
            set.add(voteForChoice.getChoiceId());
            lastVoteForChoice = voteForChoice;
        }
        return result;
    }

    public Set<String> getDirectWinners(Collection<List<Set<String>>> values) {
        Set<String> result = null;
        for (List<Set<String>> value : values) {
            Set<String> topChoices = value.get(0);
            if (result == null) {
                result = topChoices;
                continue;
            }
            if (result.equals(topChoices)) continue;
            result = null;
            break;
        }
        return result;
    }

    public static class VoteForChoiceComparator
    implements Comparator<VoteForChoice>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(VoteForChoice o1, VoteForChoice o2) {
            Double v1 = o1.getVoteValue();
            Double v2 = o2.getVoteValue();
            if (v1 == null) {
                v1 = Double.MAX_VALUE;
            }
            if (v2 == null) {
                v2 = Double.MAX_VALUE;
            }
            return v1.intValue() - v2.intValue();
        }
    }
}

