/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.entity.VoterListMemberDao;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class VoterListDao
extends AbstractPollenDao<VoterList> {
    @Override
    public Class<VoterList> getEntityClass() {
        return VoterList.class;
    }

    public void deleteFromParent(VoterList entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getVoterListMemberDao().forVoterListEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((VoterListMember)item).getVoterList())) continue;
            ((VoterListMember)item).setVoterList(null);
        }
        list = this.daoSupplier.getVoterListDao().forProperties("parent", entity, new Object[0]).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((VoterList)item).getParent())) continue;
            ((VoterList)item).setParent(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<VoterList> forPollEquals(Poll v) {
        return this.forEquals("poll", v);
    }

    public AddCriteriaOrRunQueryStep<VoterList> forParentEquals(VoterList v) {
        return this.forEquals("parent", v);
    }

    @Override
    public void delete(VoterList entity) {
        VoterListMemberDao dao = this.daoSupplier.getVoterListMemberDao();
        List list = dao.forVoterListEquals(entity).findAll();
        dao.deleteAll(list);
        List children = this.forParentEquals(entity).findAll();
        this.deleteAll(children);
        this.deleteFromParent(entity);
    }

    public List<VoterListMember> getAllMembers(VoterList entity) {
        VoterListMemberDao dao = this.daoSupplier.getVoterListMemberDao();
        List<VoterListMember> members = dao.forVoterListEquals(entity).findAll();
        for (VoterList subVoterList : this.forParentEquals(entity).findAll()) {
            members.addAll(this.getAllMembers(subVoterList));
        }
        return members;
    }
}

