/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.exec;

import fr.ifremer.isisfish.util.exec.ExecMonitor;
import fr.ifremer.isisfish.util.exec.ExecResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class ExecHelper {
    public static ExecResult exec(String command, String ... args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>(args.length + 1);
        cmd.add(command);
        cmd.addAll(Arrays.asList(args));
        ExecResult result = new ExecResult();
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        long before = System.nanoTime();
        Process process = processBuilder.start();
        ExecMonitor.registerProcess(process);
        String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
        result.setOutput(output);
        String error = IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8);
        result.setError(error);
        int status = process.waitFor();
        long after = System.nanoTime();
        result.setReturnCode(status);
        result.setTime((after - before) / 1000000L);
        return result;
    }
}

