/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.status;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.WelcomeUI;
import fr.ifremer.isisfish.ui.widget.status.DiskStatus;
import fr.ifremer.isisfish.ui.widget.status.MemoryStatus;
import fr.ifremer.isisfish.util.IsisFileUtil;
import fr.ifremer.isisfish.util.UIUtil;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class StatusBar
extends JPanel {
    private static final Log log = LogFactory.getLog(StatusBar.class);
    protected JProgressBar progressBar;
    protected JLabel messageLabel;
    protected JFileChooser screenshotFileChooser;

    public StatusBar() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
        this.progressBar = new JProgressBar();
        this.add((Component)this.progressBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 3, 1, 3), 0, 0));
        this.messageLabel = new JLabel();
        this.add((Component)this.messageLabel, new GridBagConstraints(1, 0, 1, 1, 5.0, 0.0, 10, 2, new Insets(1, 3, 1, 3), 0, 0));
        Box indicatorPanel = Box.createHorizontalBox();
        this.add((Component)indicatorPanel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(1, 3, 1, 3), 0, 0));
        indicatorPanel.add(new JLabel(UIUtil.getIconImage("/icons/fatcow/ddr_memory.png")));
        indicatorPanel.add(Box.createHorizontalStrut(3));
        indicatorPanel.add(new MemoryStatus());
        indicatorPanel.add(Box.createHorizontalStrut(3));
        indicatorPanel.add(new JLabel(UIUtil.getIconImage("/icons/fatcow/disk_space.png")));
        indicatorPanel.add(Box.createHorizontalStrut(3));
        indicatorPanel.add(new DiskStatus(new File(IsisFish.config.getIsisHomeDirectory())));
        indicatorPanel.add(new JSeparator(1));
        indicatorPanel.add(Box.createHorizontalStrut(3));
        JLabel screenshotLabel = new JLabel(UIUtil.getIconImage("/icons/fatcow/camera.png"));
        screenshotLabel.setToolTipText(I18n.t((String)"isisfish.status.screenshot", (Object[])new Object[0]));
        screenshotLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatusBar.this.takeScreenshot();
            }
        });
        indicatorPanel.add(screenshotLabel);
    }

    public void setStatusMessage(String message) {
        this.setStatusMessage(message, false);
    }

    public void setStatusMessage(String message, boolean state) {
        this.progressBar.setIndeterminate(state);
        this.messageLabel.setText(message);
    }

    protected void takeScreenshot() {
        block6: {
            File previousFile;
            if (this.screenshotFileChooser == null) {
                this.screenshotFileChooser = new JFileChooser();
                this.screenshotFileChooser.setFileSelectionMode(0);
                this.screenshotFileChooser.setMultiSelectionEnabled(false);
            }
            if ((previousFile = this.screenshotFileChooser.getSelectedFile()) != null) {
                this.screenshotFileChooser.setSelectedFile(new File(""));
                this.screenshotFileChooser.setCurrentDirectory(previousFile.getParentFile());
            }
            Container parent = this;
            while (!(parent instanceof WelcomeUI)) {
                parent = parent.getParent();
            }
            StatusBar realParent = parent;
            try {
                Rectangle screenRect = realParent.getBounds();
                BufferedImage capture = new Robot().createScreenCapture(screenRect);
                int opt = this.screenshotFileChooser.showSaveDialog(realParent);
                if (opt == 0) {
                    File file = this.screenshotFileChooser.getSelectedFile();
                    File realFile = file = IsisFileUtil.addExtensionIfNeeded(file, "png");
                    ImageIO.write((RenderedImage)capture, "png", realFile);
                }
            }
            catch (AWTException | IOException ex) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't take screenshot help", (Throwable)ex);
            }
        }
    }
}

