/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.simulator.ExportUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(ExportHandler.class);
    protected ExportUI tabUI;
    protected StorageChangeListener exportStorageListener;

    protected ExportHandler(ExportUI tabUI) {
        super(tabUI);
        this.tabUI = tabUI;
    }

    protected void initListSimulExportChooseModel(StorageChangeEvent evt) {
        List<String> availableExports = ExportStorage.getExportNames();
        this.tabUI.listSimulExportChooseModel.setElementList(availableExports);
        List<String> paramExports = this.getParameters().getExportNames();
        this.tabUI.listSimulExportChoose.clearSelection();
        for (String userExport : paramExports) {
            int index = availableExports.indexOf(userExport);
            this.tabUI.listSimulExportChoose.addSelectionInterval(index, index);
        }
    }

    protected void afterInit() {
        this.exportStorageListener = this::initListSimulExportChooseModel;
        ExportStorage.addStorageListener(this.exportStorageListener);
        this.initListSimulExportChooseModel(null);
    }

    public void refresh() {
        this.initListSimulExportChooseModel(null);
    }

    protected void saveSimulationExports(ListSelectionEvent event) {
        LinkedList<String> exportNames = new LinkedList<String>(this.tabUI.listSimulExportChoose.getSelectedValuesList());
        this.getParameters().setExportNames(exportNames);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set exports in simulation : " + String.valueOf(exportNames)));
        }
    }

    protected void saveConfigExports() {
        LinkedList<String> exportNames = new LinkedList<String>(this.tabUI.listSimulExportChoose.getSelectedValuesList());
        IsisFish.config.setDefaultExportNames(exportNames);
        this.setInfoText(I18n.t((String)"isisfish.export.saved", (Object[])new Object[0]));
    }

    protected void setInfoText(String txt) {
        WelcomePanelUI root = this.tabUI.getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(txt);
    }
}

