package com.franciaflex.faxtomail.ui.swing.content.reply.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Kevin Morin (Code Lutin)
 * @since 1.4
 */
public class SaveSigningAction extends AbstractFaxToMailAction<SigningSettingsUIModel, SigningSettingsUI, SigningSettingsUIHandler> {

    /**
     * Logger.
     */
    private static final Log log = LogFactory.getLog(SaveSigningAction.class);

    public SaveSigningAction(SigningSettingsUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        SigningSettingsUIModel model = getModel();
        Stamp signing = model.getSelectedSigning();
        signing.setLabel(model.getSelectedSigningName());
        signing.setText(model.getSelectedSigningText());

        FaxToMailUser user = getContext().getCurrentUser();

        UserService userService = getContext().newServiceContext().getUserService();
        userService.saveSigning(user, signing, user.isSigningsEmpty());

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        SigningSettingsUIModel model = getModel();
        model.updateSetDefaultButtonEnabled();
        model.setModified(false);
        getUI().getSigningList().repaint();
    }
}
