/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DataReadQuery;

public class DirectReadQuery
extends DataReadQuery {
    protected Converter valueConverter;

    public DirectReadQuery() {
    }

    public DirectReadQuery(String sqlString) {
        super(sqlString);
    }

    public DirectReadQuery(Call call) {
        super(call);
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public Object buildObject(AbstractRecord row) {
        Object value = row.get(row.getFields().firstElement());
        if (this.getValueConverter() != null) {
            value = this.getValueConverter().convertDataValueToObjectValue(value, this.session);
        }
        return value;
    }

    public Object executeNonCursor() throws DatabaseException, QueryException {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector rows = this.getQueryMechanism().executeSelect();
        Object result = cp.containerInstance(rows.size());
        DatabaseField resultDirectField = null;
        Enumeration stream = rows.elements();
        while (stream.hasMoreElements()) {
            AbstractRecord row = (AbstractRecord)stream.nextElement();
            if (resultDirectField == null) {
                resultDirectField = (DatabaseField)row.getFields().firstElement();
            }
            Object value = row.get(resultDirectField);
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertDataValueToObjectValue(value, this.session);
            }
            cp.addInto(value, result, this.getSession());
        }
        return result;
    }
}

