/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.spi.SystemOfUnits;
import systems.uom.common.CGS;
import systems.uom.common.Imperial;
import systems.uom.common.USCustomary;
import tech.units.indriya.spi.AbstractSystemOfUnitsService;

public class CommonSystemService
extends AbstractSystemOfUnitsService {
    private static final String DEFAULT_SYSTEM_NAME = "USCustomary";
    private final Map<String, String> aliases = new HashMap<String, String>();

    public CommonSystemService() {
        this.souMap.put("Imperial", Imperial.getInstance());
        this.souMap.put(DEFAULT_SYSTEM_NAME, USCustomary.getInstance());
        this.souMap.put("CGS", CGS.getInstance());
        this.aliases.put("US", DEFAULT_SYSTEM_NAME);
        this.aliases.put("Centimetre\u2013gram\u2013second", "CGS");
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return this.souMap.values();
    }

    public SystemOfUnits getSystemOfUnits() {
        return this.getSystemOfUnits(DEFAULT_SYSTEM_NAME);
    }

    public SystemOfUnits getSystemOfUnits(String name) {
        String alias = this.aliases.get(name);
        if (alias != null && alias.length() > 0) {
            return (SystemOfUnits)this.souMap.get(alias);
        }
        return (SystemOfUnits)this.souMap.get(name);
    }
}

