/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Displays errors that occurred during validation of the resource policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationErrorsEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationErrorsEntry.Builder, ValidationErrorsEntry> {
    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckName").getter(getter(ValidationErrorsEntry::checkName)).setter(setter(Builder::checkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckName").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ValidationErrorsEntry::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_NAME_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String checkName;

    private final String errorMessage;

    private ValidationErrorsEntry(BuilderImpl builder) {
        this.checkName = builder.checkName;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Checks the name of the policy.
     * </p>
     * 
     * @return Checks the name of the policy.
     */
    public final String checkName() {
        return checkName;
    }

    /**
     * <p>
     * Displays error messages if validation encounters problems during validation of the resource policy.
     * </p>
     * 
     * @return Displays error messages if validation encounters problems during validation of the resource policy.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkName());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationErrorsEntry)) {
            return false;
        }
        ValidationErrorsEntry other = (ValidationErrorsEntry) obj;
        return Objects.equals(checkName(), other.checkName()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationErrorsEntry").add("CheckName", checkName()).add("ErrorMessage", errorMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckName":
            return Optional.ofNullable(clazz.cast(checkName()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationErrorsEntry, T> g) {
        return obj -> g.apply((ValidationErrorsEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationErrorsEntry> {
        /**
         * <p>
         * Checks the name of the policy.
         * </p>
         * 
         * @param checkName
         *        Checks the name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkName(String checkName);

        /**
         * <p>
         * Displays error messages if validation encounters problems during validation of the resource policy.
         * </p>
         * 
         * @param errorMessage
         *        Displays error messages if validation encounters problems during validation of the resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String checkName;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationErrorsEntry model) {
            checkName(model.checkName);
            errorMessage(model.errorMessage);
        }

        public final String getCheckName() {
            return checkName;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ValidationErrorsEntry build() {
            return new ValidationErrorsEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
