/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum FilterNameStringType {
    DESCRIPTION("description"),

    NAME("name"),

    TAG_KEY("tag-key"),

    TAG_VALUE("tag-value"),

    PRIMARY_REGION("primary-region"),

    OWNING_SERVICE("owning-service"),

    ALL("all"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterNameStringType> VALUE_MAP = EnumUtils.uniqueIndex(FilterNameStringType.class,
            FilterNameStringType::toString);

    private final String value;

    private FilterNameStringType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return FilterNameStringType corresponding to the value
     */
    public static FilterNameStringType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link FilterNameStringType}s
     */
    public static Set<FilterNameStringType> knownValues() {
        Set<FilterNameStringType> knownValues = EnumSet.allOf(FilterNameStringType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
