/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataKeySpec {
    AES_256("AES_256"),
    AES_128("AES_128"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataKeySpec> VALUE_MAP;
    private final String value;

    private DataKeySpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataKeySpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataKeySpec> knownValues() {
        EnumSet<DataKeySpec> knownValues = EnumSet.allOf(DataKeySpec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataKeySpec.class, DataKeySpec::toString);
    }
}

